#include "mbed.h"
#include "HTTPServer.h"
#include "HTTPFS.h"
#include "HTTPWebSocketHandler.h"
#include "HTTPRestHandler.h"

DigitalIn maskSense(p10);

HTTPServer httpd (
    "mBed",                 // hostname
    IPv4(192,168,maskSense?42:24,42),    // IP address
    IPv4(255,255,255,0),    // Netmask
    IPv4(192,168,maskSense?42:24,1),     // Gateway
    IPv4(192,168,maskSense?42:24,1),     // DNS
    80                      // Port
);

LocalFileSystem local("local");
DigitalOut led1(LED1);
TemperatureSensor sensor;
RGBLed rgb;

int main() {
    httpd.addHandler(new HTTPWebSocketHandler("/ws"));
    httpd.addHandler(new HTTPRestHandler("/io"));
    httpd.addHandler(new HTTPFileSystemHandler("/", "/local/"));
    httpd.bind();

    Timer tm;
    tm.start();
    printf("Listening...\n");
    while (1) {
        httpd.poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
}
