#include "RGBLed.h"

RGBLed::RGBLed() : red(p23), green(p22), blue(p21) {
    red.period(0.001);
    green.period(0.001);
    blue.period(0.001);

    setRgb(0.1, 0.1, 0.1);
}

void RGBLed::setRgb(char *rgb) {
    float r, g, b;
    int value;

    value= parseHex(0, *rgb++);
    value= parseHex(value, *rgb++);
    r= value / 255.0f;

    value= parseHex(0, *rgb++);
    value= parseHex(value, *rgb++);
    g= value / 255.0f;

    value= parseHex(0, *rgb++);
    value= parseHex(value, *rgb++);
    b= value / 255.0f;

    setRgb(r, g, b);
}

void RGBLed::setRgb(float r, float g, float b) {
    red= 1.0 - r;
    green= 1.0 - g;
    blue= 1.0 - b;

    //printf("red:%0.3f green:%0.3f blue%0.3f\n", r, g, b);
}

int RGBLed::parseHex(int value, char hex) {
    switch (hex) {
        case '0':
            return value<<4;
        case '1':
            return value<<4 | 1;
        case '2':
            return value<<4 | 2;
        case '3':
            return value<<4 | 3;
        case '4':
            return value<<4 | 4;
        case '5':
            return value<<4 | 5;
        case '6':
            return value<<4 | 6;
        case '7':
            return value<<4 | 7;
        case '8':
            return value<<4 | 8;
        case '9':
            return value<<4 | 9;
        case 'A':
        case 'a':
            return value<<4 | 10;
        case 'B':
        case 'b':
            return value<<4 | 11;
        case 'C':
        case 'c':
            return value<<4 | 12;
        case 'D':
        case 'd':
            return value<<4 | 13;
        case 'E':
        case 'e':
            return value<<4 | 14;
        case 'F':
        case 'f':
            return value<<4 | 15;
        default:
            return value;
    }
}
