#include <TemperatureSensor.h>
#include <math.h>

TemperatureSensor::TemperatureSensor():adc(p20) {
    percentOfScale= adc.read();
}

void TemperatureSensor::measure(void) {
    static const float R= 10500.0;
    static const float LP= 0.01;
    
    percentOfScale= ((1.0 - LP) * percentOfScale) + (LP * adc.read());
    resistance= (percentOfScale * R) / (1.0 - percentOfScale);
}

float TemperatureSensor::getKelvin(void) {
    float x;

    // Compute the Steinhard-Hart eqn:  1/t = A + B*ln(r) + C*ln(r)^3 + D*ln(r)^5
    static const float A= 1.006389097E-3;
    static const float B= 2.425678347E-4;
    static const float C= 1.452612422E-7;

    x= log(resistance);
    return 1.0 / (A + (B * x) + (C * x * x * x));
}

float TemperatureSensor::getResistance(void) {
    return resistance;
}

float TemperatureSensor::getPercentOfScale(void) {
    return percentOfScale;
}