#include "mbed.h"
#include "stm32746g_discovery_audio.h"
#include "LCD_DISCO_F746NG.h"

#define PI              ((double)3.1415926535897932384626433832795028)
#define SamplingFreq    I2S_AUDIOFREQ_16K
#define BufferSize      (1024)                          /* Sample Size */
#define BufferByteSize  (BufferSize * AUDIODATA_SIZE)   /* Byte Size */

#define AudioVolume     ((uint8_t)8)
#define Amplifier       ((double)0.25)

#define MaxFreq         ((double)8000)
#define MinFreq         ((double)50)
#define SweepSpeed      ((double)0.01)

extern LCD_DISCO_F746NG lcd;
extern DigitalOut led1;
extern int16_t sweep_buffer[BufferSize];

void AUDIO_OUT_SAIx_DMAx_IRQHandler();

void error_trap();
void printlcd(const char *str);
void printlcdAt(const char *str, uint16_t line);

void fill_buffer(uint32_t offset, uint32_t size);
