#include "main.h"

LCD_DISCO_F746NG lcd;
int16_t sweep_buffer[BufferSize];
double sweep_phase = 0.0;
double sweep_freq = MinFreq;

void init_audio()
{
    if (BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_BOTH, AudioVolume, SamplingFreq) == AUDIO_ERROR)
        error_trap();

    NVIC_SetVector(AUDIO_OUT_SAIx_DMAx_IRQ, (uint32_t)&AUDIO_OUT_SAIx_DMAx_IRQHandler);
    BSP_AUDIO_OUT_SetAudioFrameSlot(CODEC_AUDIOFRAME_SLOT_02);
}

void play_audio()
{
    if (BSP_AUDIO_OUT_Play((uint16_t*)&sweep_buffer, BufferByteSize) == AUDIO_ERROR)
        error_trap();
}

void fill_buffer(uint32_t offset, uint32_t size)
{
    static double sweep_freq_delta = 1.0 + SweepSpeed;
    double sweep_phase_delta = 1.0 / SamplingFreq;
    double new_freq;
    
    for (int i = 0, j = offset; i < size / 2; i++ ) {
        int16_t value = (int16_t)(Amplifier * sin(2.0 * PI * sweep_freq * sweep_phase) * 32767.5);
        sweep_buffer[j++] = value;
        sweep_buffer[j++] = value;

        sweep_phase += sweep_phase_delta;
    }
    
    new_freq = sweep_freq * sweep_freq_delta;
    sweep_phase = sweep_phase * sweep_freq / new_freq;
    sweep_freq = new_freq;

    if (sweep_freq > MaxFreq)
        sweep_freq_delta = 1.0 - SweepSpeed;
    else if (sweep_freq < MinFreq)
        sweep_freq_delta = 1.0 + SweepSpeed;
}

int main()
{
    char strbuf[64];

    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font12);

    init_audio();
    play_audio();

    while(1) {
        sprintf(strbuf, "Freq: %.2f Hz, Phase: %.2f  ", sweep_freq, sweep_phase);
        printlcdAt(strbuf, 0);
        wait_ms(100);
    }
}