#include "mbed.h"
#include "stm32746g_discovery_audio.h"

#define PI              ((double)3.1415926535897932384626433832795028)
#define SamplingFreq    I2S_AUDIOFREQ_16K
#define BufferSize      (SamplingFreq * DEFAULT_AUDIO_IN_CHANNEL_NBR)

#define AudioVolume     ((uint8_t)8)
#define Amplifier       ((double)0.25)
#define SineFreq        ((double)440.0)

/* 注意:
 * AudioVolume で AudioOut のボリュームが設定できるはずだが、
 * 現時点のライブラリだと、たとえば 0 だと大音量で再生される。
 */

DigitalOut led1(LED1);
int16_t buffer[BufferSize];

void error_trap()
{
    while(1) {
        led1 = !led1;
        wait_ms(250);
    }
}

void init_audio()
{
    if (BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_BOTH, AudioVolume, SamplingFreq) == AUDIO_ERROR)
        error_trap();
    
    BSP_AUDIO_OUT_SetAudioFrameSlot(CODEC_AUDIOFRAME_SLOT_02);
}

void play_audio()
{
    /* Generate sine wave */
    for (int i = 0; i < SamplingFreq; i++) {
        buffer[i * 2 + 1] =
            buffer[i * 2 + 0] =
                (int16_t)(Amplifier * sin(2.0 * PI * SineFreq * i / SamplingFreq) * 32767.5);
    }
        
    if (BSP_AUDIO_OUT_Play((uint16_t*)&buffer, BufferSize * AUDIODATA_SIZE) == AUDIO_ERROR)
        error_trap();
}

int main()
{
    init_audio();
    play_audio();

    while(1)
        wait(1);
}