#include "main.h"

LCD_DISCO_F746NG lcd;

int16_t audio_in_buffer[BufferSize];
__IO bool audio_in_buffer_captured = false;
__IO int32_t audio_in_buffer_offset = 0;
__IO int32_t audio_in_buffer_length = 0;

void init_audio_in()
{
    if (BSP_AUDIO_IN_Init(INPUT_DEVICE_INPUT_LINE_1, AudioInVolume, SamplingFreq) == AUDIO_ERROR)
        error_trap();

    NVIC_SetVector(AUDIO_IN_SAIx_DMAx_IRQ, (uint32_t)&AUDIO_IN_SAIx_DMAx_IRQHandler);
}

void record_audio_in()
{
    if (BSP_AUDIO_IN_Record((uint16_t*)&audio_in_buffer[0], BufferByteSize / 2) == AUDIO_ERROR)
        error_trap();
}


int main()
{
    char strbuf[64];
    uint16_t width, height, height_2, graph_height;
    double y_factor;

    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font12);
    sprintf(strbuf, "SamplingFreq: %d Hz", SamplingFreq);
    lcd.DisplayStringAt(0, 0, (uint8_t *)strbuf, LEFT_MODE);

    width = lcd.GetXSize() - 1;
    height = lcd.GetYSize() - 1;
    graph_height = height - LINE(1);
    height_2 = graph_height / 2;
    y_factor = (graph_height * 0.5 * AudioInGraphYFactor) / 32768.0;

    init_audio_in();
    record_audio_in();
    
    while(1) {
        if (audio_in_buffer_captured) {
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.FillRect(0, LINE(1), width, graph_height);
            lcd.SetTextColor(LCD_COLOR_WHITE);

            for (int32_t i = audio_in_buffer_offset, j = 0; j < audio_in_buffer_length / 2 - 1 && j < width - 1; j++) {
                uint16_t k = (uint16_t)j;
                int16_t y1 =  (int16_t)(audio_in_buffer[i + 0] * y_factor);
                int16_t y2 =  (int16_t)(audio_in_buffer[i + 4] * y_factor);

                if (y1 > height_2)
                    y1 = height_2;
                else if (y1 < -height_2)
                    y1 = -height_2;

                if (y2 > height_2)
                    y2 = height_2;
                else if (y2 < -height_2)
                    y2 = -height_2;

                lcd.DrawLine(k, (uint16_t)(height_2 + y1 + LINE(1)), k + 1, (uint16_t)(height_2 + y2 + LINE(1)));

                i += 4;
            }
            audio_in_buffer_captured = false;
        }

        wait_ms(AudioInLCDInterval);
    }
}