#include "mbed.h"
#include "stm32746g_discovery_audio.h"
#include "LCD_DISCO_F746NG.h"

#define PI                      ((double)3.1415926535897932384626433832795028)
#define SamplingFreq            I2S_AUDIOFREQ_32K

#define BufferSize              (4096)                          /* Sample Size */
#define BufferByteSize          (BufferSize * AUDIODATA_SIZE)   /* Byte Size */

#define AudioInLCDInterval      (RK043FN48H_VSYNC * RK043FN48H_FREQUENCY_DIVIDER)
#define AudioInGraphYFactor     ((double)6.0)
#define AudioInVolume           (86)

extern LCD_DISCO_F746NG lcd;
extern DigitalOut led1;

extern int16_t audio_in_buffer[BufferSize];
extern __IO bool audio_in_buffer_captured;
extern __IO int32_t audio_in_buffer_offset;
extern __IO int32_t audio_in_buffer_length;

void AUDIO_IN_SAIx_DMAx_IRQHandler();

void error_trap();
void printlcd(const char *str);
void printlcdAt(const char *str, uint16_t line);
