
#include <stdio.h>
#include "mbed.h"
#include "X_NUCLEO_NFC01A1.h"
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/RecordType/RecordURI.h"
#include "NDefLib/RecordType/RecordText.h"
#include "x_nucleo_iks01a1.h"

/* Instantiate the expansion board */

static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
//static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor1;// = mems_expansion_board->ht_sensor;

     //use default board pinout
    I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
    X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel,NULL,
            X_NUCLEO_NFC01A1::DEFAULT_GPO_PIN,X_NUCLEO_NFC01A1::DEFAULT_RF_DISABLE_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED1_PIN,X_NUCLEO_NFC01A1::DEFAULT_LED2_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED3_PIN);

    char itoc(int i){
        return i+ 0x30;
    }
/**
 * Write a Ndef URI message linking to st.com site.
 */
float Temp(float temp)
{
    temp_sensor1 = mems_expansion_board->ht_sensor;
    temp_sensor1->GetTemperature(&temp);
    return temp;
} 
int NFC_send(char c[]){

 
 printf("System Init done: !\n\r");
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    
    //open the i2c session with the nfc chip
    if(tag.openSession()){
        printf("Session opened\n\r");
        nfcNucleo->getLed1()=1;
        
        //create the NDef message and record
        NDefLib::Message msg;
        //::RecordURI rUri(NDefLib::RecordURI::FILE,c);
        NDefLib::RecordText rUri(c);
       
        msg.addRecord(&rUri);

        //write the tag
        if(tag.write(msg) && tag.closeSession()){
            printf("Tag written\n\r");
            nfcNucleo->getLed2()=1;
           // nfcNucleo->getLed3()=1;               //상태확인
            return 0;
       }else{
           printf("Error writing \n\r");
           return 0;
        }//if-else

        //close the i2c session
  /*      if(tag.closeSession()){
           printf("Session closed\n\r");
           nfcNucleo->getLed3()=0;
           return 0;
             // That's point stop
        }else{
           printf("Error closing the session\n\r");
           return 0;
        }//if-else
         */   
    }else
        printf("Error opening the session\n\r");
    return 0;
 } 
 
 
void Temp_NFC(float temp){

    char c[7];
    int i=0;

    

    //float temp;
    //temp=Temp(temp);
    //온도값을 최대를 100자리와 소숫점 첫자리까지 결과로 코딩
    c[3]='.'; //소숫점  
    c[5]=0X60;
    c[6]='C';

    i=temp*10;
    i=i%10;  //소숫점아랫자리
    c[4]=itoc(i);

    i=temp/1;  //1자리
    i=i%10;
    c[2]=itoc(i);

    i=temp/10; //10자리
    i=i%10;
    c[1]=itoc(i);
 
    i=temp/100;//100자리
    i=i%10;
    if(i>0) c[0]=itoc(i);
    else c[0]='0';
    
    
    NFC_send(c);
    
    /*retrieve the NdefLib interface
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    tag.openSession();
    NDefLib::Message msg;
        //::RecordURI rUri(NDefLib::RecordURI::FILE,c);
    NDefLib::RecordText rUri(c);
       
    msg.addRecord(&rUri);
    wait(0.1);
    tag.closeSession();
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
        
    printf("System Init done: !\n\r");
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    
    //open the i2c session with the nfc chip
    if(tag.openSession()){
        printf("Session opened\n\r");
        nfcNucleo->getLed1()=1;
        
        //create the NDef message and record
        NDefLib::Message msg;
        //::RecordURI rUri(NDefLib::RecordURI::FILE,c);
        NDefLib::RecordText rUri(c);
       
        msg.addRecord(&rUri);

        //write the tag
        if(tag.write(msg)){
            printf("Tag written\n\r");
            nfcNucleo->getLed2()=1;
       }else{
           printf("Error writing \n\r");
        }//if-else

        //close the i2c session
        if(tag.closeSession()){
           printf("Session closed\n\r");
           nfcNucleo->getLed3()=1;
        }else{
           printf("Error closing the session\n\r");
        }//if-else
            
    }else
        printf("Error opening the session\n\r");
 */

}


int main()
{
   float temp;
   while(1){
    temp = Temp(temp);
    Temp_NFC(temp);
    nfcNucleo->getLed3()=1;  
    wait(0.1);
    nfcNucleo->getLed3()=0;  
    wait(0.1);
    
}
}