#include "mbed.h"
#include <wave_player.h>

////////////////////////////////////////
////////    general setting     ////////
////////////////////////////////////////
//#define     USE_TextLCD_20x4
#define     USE_FIXED_IP

////////////////////////////////////////
////////    For TextLCD         ////////
////////////////////////////////////////
#include "TextLCD.h"
#ifdef  USE_TextLCD_20x4
//TextLCD     lcd( p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4 ); // rs, e, d0-d3
#else
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

////////////////////////////////////////
////////    For SD_card         ////////
////////////////////////////////////////
#include "SDFileSystem.h"
//SDFileSystem    sd(p5, p6, p7, p13, "sd");  //  mosi, miso, sclk, cs, name
SDFileSystem  sd(p5, p6, p7, p8,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

AnalogOut       DACout(p18);
wave_player     waver(&DACout);


void test_TextLCD( void );
void test_file_write( char *title, char *path );
int  position( void );

int main() {
    FILE  *fp;
    fp = fopen("/sd/test.wav","r");
    if (fp == NULL) {
        lcd.locate( 0, 0 );
        lcd.printf("File couldn't open\n");
    } else {
        lcd.locate( 0, 0 );
        lcd.printf("Open ok\n");
    }
    while (1) {
        lcd.locate( 0, 1 );
        lcd.printf("File Playing\n");
        waver.play(fp);
    }
    fclose(fp);
}


void test_TextLCD( void ) {
    //  TextLCD test

#ifdef  USE_TextLCD_20x4
    lcd.locate( 0, 0 );
    for ( int i = 0, c = '0'; i < 20; i++, c++ )
        lcd.putc( c );

    for ( int i = 0, c = 'A'; i < 20; i++, c++ )
        lcd.putc( c );

    for ( int i = 0, c = 'a'; i < 20; i++, c++ )
        lcd.putc( c );
    for ( int i = 0, c = '0' - 10; i < 20; i++, c++ )
        lcd.putc( c );
    exit( 0 );
    wait( 300 );
    lcd.cls();
#endif  //  USE_TextLCD_20x4

    lcd.locate( 0, 0 );
    lcd.printf( "TextLCD: OK?" );
    lcd.locate( 0, 1 );
    lcd.printf( "" );

}

void test_file_write( char *title, char *path ) {
    //  SD card test
    lcd.locate( 0, position() );
    lcd.printf( "%s: ", title );

    FILE *fp = fopen( path, "w" );
    if ( fp == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
    }
    fprintf( fp, "The mbed writing a file through the star board orange (%s)!", title );
    fclose( fp );

    lcd.printf( "OK." );
}

int position( void ) {
    static int  p   = 0;

#ifdef  USE_TextLCD_20x4
    return( ++p % 4 );
#else
    return( ++p % 2 );
#endif
}