#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <cwchar>

int utf8tosjis(const char* utfBuffer, int utfBufLen, char* sjisBuffer, int sjisBufLen)
{
    wchar_t wstr[256];
    int         i, wi;
    wchar_t     wc;
    mbstate_t   state = {0};
    size_t      ret;
    char *      current_locale;
    i = wi = 0;

    current_locale = setlocale(LC_CTYPE, "UTF-8");
    if (current_locale == NULL)
        return 0;

    while (1) {
        ret = mbrtowc(&wc, utfBuffer+i, 3, &state);
        if (ret == (size_t)-2 || ret == (size_t)-1) {
            printf("\nThere was a problem decoding the multibyte string.\n");
            return ret;
        } else if (ret == 0) {
            break;          /* we hit \0, end of string */
        } else {
            i += ret;
            wstr[wi++] = wc;
        }
    }
    wstr[wi] = L'\0';
    
    current_locale = setlocale(LC_CTYPE, "SJIS");
    if (current_locale == NULL)
        return 0;

    ret = wcstombs(sjisBuffer, wstr, sjisBufLen);

    return ret;
}