#pragma import __use_all_ctype

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "utf8tosjis.h"
#include <string.h>

EthernetNetIf eth;
HTTPClient http;
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    char  buf_s[256];
    char  buf_u[256];

    printf("Setting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\r\n", ethErr);
        return -1;
    }
    printf("Setup OK\r\n");

    HTTPText txt;
    HTTPMap token;
    token["_t"] = "";//input token
    //token["msg"] = "test";  

    HTTPResult r = http.post("http://stewgate-u.appspot.com/api/last_mention/", token, &txt);

    if(r==HTTP_OK)
    {
      printf("Result :\"%s\"\r\n", txt.gets()); 
    }
    else
    {
      printf("Error %d\r\n", r);
    }

    strcpy(buf_u, txt.gets());  
    size_t sz;
    // assuming UTF-8 is NULL terminated
    sz = strlen(buf_u);
    
    printf("\r\nUTF-8:\r\n");
    for(int i=0; i<sz; i++) {
        printf("0x%02x ", buf_u[i]);
    }

    int len = utf8tosjis(buf_u, sz, buf_s, sizeof(buf_s));

    printf("\r\nSJIS:\r\n");
    if (len != -1) {
        for(int i=0; i<len; i++) {
            printf("0x%02x ", buf_s[i]);
        }
        printf("\r\n");
    }
    printf("%s", buf_s);
    
    while(1)
    {
    }
    return 0;
}
