/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_FMC_REGISTERS_H__
#define __HW_FMC_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 FMC
 *
 * Flash Memory Controller
 *
 * Registers defined in this header file:
 * - HW_FMC_PFAPR - Flash Access Protection Register
 * - HW_FMC_PFB0CR - Flash Bank 0 Control Register
 * - HW_FMC_PFB1CR - Flash Bank 1 Control Register
 * - HW_FMC_TAGVDW0Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW1Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW2Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW3Sn - Cache Tag Storage
 * - HW_FMC_DATAW0SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW0SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW1SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW1SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW2SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW2SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW3SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW3SnL - Cache Data Storage (lower word)
 *
 * - hw_fmc_t - Struct containing all module registers.
 */

#define HW_FMC_INSTANCE_COUNT (1U) /*!< Number of instances of the FMC module. */

/*******************************************************************************
 * HW_FMC_PFAPR - Flash Access Protection Register
 ******************************************************************************/

/*!
 * @brief HW_FMC_PFAPR - Flash Access Protection Register (RW)
 *
 * Reset value: 0x00F8003FU
 */
typedef union _hw_fmc_pfapr
{
    uint32_t U;
    struct _hw_fmc_pfapr_bitfields
    {
        uint32_t M0AP : 2;             /*!< [1:0] Master 0 Access Protection */
        uint32_t M1AP : 2;             /*!< [3:2] Master 1 Access Protection */
        uint32_t M2AP : 2;             /*!< [5:4] Master 2 Access Protection */
        uint32_t M3AP : 2;             /*!< [7:6] Master 3 Access Protection */
        uint32_t M4AP : 2;             /*!< [9:8] Master 4 Access Protection */
        uint32_t M5AP : 2;             /*!< [11:10] Master 5 Access Protection */
        uint32_t M6AP : 2;             /*!< [13:12] Master 6 Access Protection */
        uint32_t M7AP : 2;             /*!< [15:14] Master 7 Access Protection */
        uint32_t M0PFD : 1;            /*!< [16] Master 0 Prefetch Disable */
        uint32_t M1PFD : 1;            /*!< [17] Master 1 Prefetch Disable */
        uint32_t M2PFD : 1;            /*!< [18] Master 2 Prefetch Disable */
        uint32_t M3PFD : 1;            /*!< [19] Master 3 Prefetch Disable */
        uint32_t M4PFD : 1;            /*!< [20] Master 4 Prefetch Disable */
        uint32_t M5PFD : 1;            /*!< [21] Master 5 Prefetch Disable */
        uint32_t M6PFD : 1;            /*!< [22] Master 6 Prefetch Disable */
        uint32_t M7PFD : 1;            /*!< [23] Master 7 Prefetch Disable */
        uint32_t RESERVED0 : 8;        /*!< [31:24]  */
    } B;
} hw_fmc_pfapr_t;

/*!
 * @name Constants and macros for entire FMC_PFAPR register
 */
/*@{*/
#define HW_FMC_PFAPR_ADDR(x)     ((x) + 0x0U)

#define HW_FMC_PFAPR(x)          (*(__IO hw_fmc_pfapr_t *) HW_FMC_PFAPR_ADDR(x))
#define HW_FMC_PFAPR_RD(x)       (HW_FMC_PFAPR(x).U)
#define HW_FMC_PFAPR_WR(x, v)    (HW_FMC_PFAPR(x).U = (v))
#define HW_FMC_PFAPR_SET(x, v)   (HW_FMC_PFAPR_WR(x, HW_FMC_PFAPR_RD(x) |  (v)))
#define HW_FMC_PFAPR_CLR(x, v)   (HW_FMC_PFAPR_WR(x, HW_FMC_PFAPR_RD(x) & ~(v)))
#define HW_FMC_PFAPR_TOG(x, v)   (HW_FMC_PFAPR_WR(x, HW_FMC_PFAPR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_PFAPR bitfields
 */

/*!
 * @name Register FMC_PFAPR, field M0AP[1:0] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M0AP    (0U)          /*!< Bit position for FMC_PFAPR_M0AP. */
#define BM_FMC_PFAPR_M0AP    (0x00000003U) /*!< Bit mask for FMC_PFAPR_M0AP. */
#define BS_FMC_PFAPR_M0AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M0AP. */

/*! @brief Read current value of the FMC_PFAPR_M0AP field. */
#define BR_FMC_PFAPR_M0AP(x) (HW_FMC_PFAPR(x).B.M0AP)

/*! @brief Format value for bitfield FMC_PFAPR_M0AP. */
#define BF_FMC_PFAPR_M0AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M0AP) & BM_FMC_PFAPR_M0AP)

/*! @brief Set the M0AP field to a new value. */
#define BW_FMC_PFAPR_M0AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M0AP) | BF_FMC_PFAPR_M0AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M1AP[3:2] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M1AP    (2U)          /*!< Bit position for FMC_PFAPR_M1AP. */
#define BM_FMC_PFAPR_M1AP    (0x0000000CU) /*!< Bit mask for FMC_PFAPR_M1AP. */
#define BS_FMC_PFAPR_M1AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M1AP. */

/*! @brief Read current value of the FMC_PFAPR_M1AP field. */
#define BR_FMC_PFAPR_M1AP(x) (HW_FMC_PFAPR(x).B.M1AP)

/*! @brief Format value for bitfield FMC_PFAPR_M1AP. */
#define BF_FMC_PFAPR_M1AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M1AP) & BM_FMC_PFAPR_M1AP)

/*! @brief Set the M1AP field to a new value. */
#define BW_FMC_PFAPR_M1AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M1AP) | BF_FMC_PFAPR_M1AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M2AP[5:4] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M2AP    (4U)          /*!< Bit position for FMC_PFAPR_M2AP. */
#define BM_FMC_PFAPR_M2AP    (0x00000030U) /*!< Bit mask for FMC_PFAPR_M2AP. */
#define BS_FMC_PFAPR_M2AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M2AP. */

/*! @brief Read current value of the FMC_PFAPR_M2AP field. */
#define BR_FMC_PFAPR_M2AP(x) (HW_FMC_PFAPR(x).B.M2AP)

/*! @brief Format value for bitfield FMC_PFAPR_M2AP. */
#define BF_FMC_PFAPR_M2AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M2AP) & BM_FMC_PFAPR_M2AP)

/*! @brief Set the M2AP field to a new value. */
#define BW_FMC_PFAPR_M2AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M2AP) | BF_FMC_PFAPR_M2AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M3AP[7:6] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M3AP    (6U)          /*!< Bit position for FMC_PFAPR_M3AP. */
#define BM_FMC_PFAPR_M3AP    (0x000000C0U) /*!< Bit mask for FMC_PFAPR_M3AP. */
#define BS_FMC_PFAPR_M3AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M3AP. */

/*! @brief Read current value of the FMC_PFAPR_M3AP field. */
#define BR_FMC_PFAPR_M3AP(x) (HW_FMC_PFAPR(x).B.M3AP)

/*! @brief Format value for bitfield FMC_PFAPR_M3AP. */
#define BF_FMC_PFAPR_M3AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M3AP) & BM_FMC_PFAPR_M3AP)

/*! @brief Set the M3AP field to a new value. */
#define BW_FMC_PFAPR_M3AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M3AP) | BF_FMC_PFAPR_M3AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M4AP[9:8] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M4AP    (8U)          /*!< Bit position for FMC_PFAPR_M4AP. */
#define BM_FMC_PFAPR_M4AP    (0x00000300U) /*!< Bit mask for FMC_PFAPR_M4AP. */
#define BS_FMC_PFAPR_M4AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M4AP. */

/*! @brief Read current value of the FMC_PFAPR_M4AP field. */
#define BR_FMC_PFAPR_M4AP(x) (HW_FMC_PFAPR(x).B.M4AP)

/*! @brief Format value for bitfield FMC_PFAPR_M4AP. */
#define BF_FMC_PFAPR_M4AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M4AP) & BM_FMC_PFAPR_M4AP)

/*! @brief Set the M4AP field to a new value. */
#define BW_FMC_PFAPR_M4AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M4AP) | BF_FMC_PFAPR_M4AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M5AP[11:10] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M5AP    (10U)         /*!< Bit position for FMC_PFAPR_M5AP. */
#define BM_FMC_PFAPR_M5AP    (0x00000C00U) /*!< Bit mask for FMC_PFAPR_M5AP. */
#define BS_FMC_PFAPR_M5AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M5AP. */

/*! @brief Read current value of the FMC_PFAPR_M5AP field. */
#define BR_FMC_PFAPR_M5AP(x) (HW_FMC_PFAPR(x).B.M5AP)

/*! @brief Format value for bitfield FMC_PFAPR_M5AP. */
#define BF_FMC_PFAPR_M5AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M5AP) & BM_FMC_PFAPR_M5AP)

/*! @brief Set the M5AP field to a new value. */
#define BW_FMC_PFAPR_M5AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M5AP) | BF_FMC_PFAPR_M5AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M6AP[13:12] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
/*@{*/
#define BP_FMC_PFAPR_M6AP    (12U)         /*!< Bit position for FMC_PFAPR_M6AP. */
#define BM_FMC_PFAPR_M6AP    (0x00003000U) /*!< Bit mask for FMC_PFAPR_M6AP. */
#define BS_FMC_PFAPR_M6AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M6AP. */

/*! @brief Read current value of the FMC_PFAPR_M6AP field. */
#define BR_FMC_PFAPR_M6AP(x) (HW_FMC_PFAPR(x).B.M6AP)

/*! @brief Format value for bitfield FMC_PFAPR_M6AP. */
#define BF_FMC_PFAPR_M6AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M6AP) & BM_FMC_PFAPR_M6AP)

/*! @brief Set the M6AP field to a new value. */
#define BW_FMC_PFAPR_M6AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M6AP) | BF_FMC_PFAPR_M6AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M7AP[15:14] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master.
 * - 01 - Only read accesses may be performed by this master.
 * - 10 - Only write accesses may be performed by this master.
 * - 11 - Both read and write accesses may be performed by this master.
 */
/*@{*/
#define BP_FMC_PFAPR_M7AP    (14U)         /*!< Bit position for FMC_PFAPR_M7AP. */
#define BM_FMC_PFAPR_M7AP    (0x0000C000U) /*!< Bit mask for FMC_PFAPR_M7AP. */
#define BS_FMC_PFAPR_M7AP    (2U)          /*!< Bit field size in bits for FMC_PFAPR_M7AP. */

/*! @brief Read current value of the FMC_PFAPR_M7AP field. */
#define BR_FMC_PFAPR_M7AP(x) (HW_FMC_PFAPR(x).B.M7AP)

/*! @brief Format value for bitfield FMC_PFAPR_M7AP. */
#define BF_FMC_PFAPR_M7AP(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M7AP) & BM_FMC_PFAPR_M7AP)

/*! @brief Set the M7AP field to a new value. */
#define BW_FMC_PFAPR_M7AP(x, v) (HW_FMC_PFAPR_WR(x, (HW_FMC_PFAPR_RD(x) & ~BM_FMC_PFAPR_M7AP) | BF_FMC_PFAPR_M7AP(v)))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M0PFD[16] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M0PFD   (16U)         /*!< Bit position for FMC_PFAPR_M0PFD. */
#define BM_FMC_PFAPR_M0PFD   (0x00010000U) /*!< Bit mask for FMC_PFAPR_M0PFD. */
#define BS_FMC_PFAPR_M0PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M0PFD. */

/*! @brief Read current value of the FMC_PFAPR_M0PFD field. */
#define BR_FMC_PFAPR_M0PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M0PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M0PFD. */
#define BF_FMC_PFAPR_M0PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M0PFD) & BM_FMC_PFAPR_M0PFD)

/*! @brief Set the M0PFD field to a new value. */
#define BW_FMC_PFAPR_M0PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M0PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M1PFD[17] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M1PFD   (17U)         /*!< Bit position for FMC_PFAPR_M1PFD. */
#define BM_FMC_PFAPR_M1PFD   (0x00020000U) /*!< Bit mask for FMC_PFAPR_M1PFD. */
#define BS_FMC_PFAPR_M1PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M1PFD. */

/*! @brief Read current value of the FMC_PFAPR_M1PFD field. */
#define BR_FMC_PFAPR_M1PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M1PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M1PFD. */
#define BF_FMC_PFAPR_M1PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M1PFD) & BM_FMC_PFAPR_M1PFD)

/*! @brief Set the M1PFD field to a new value. */
#define BW_FMC_PFAPR_M1PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M1PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M2PFD[18] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M2PFD   (18U)         /*!< Bit position for FMC_PFAPR_M2PFD. */
#define BM_FMC_PFAPR_M2PFD   (0x00040000U) /*!< Bit mask for FMC_PFAPR_M2PFD. */
#define BS_FMC_PFAPR_M2PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M2PFD. */

/*! @brief Read current value of the FMC_PFAPR_M2PFD field. */
#define BR_FMC_PFAPR_M2PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M2PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M2PFD. */
#define BF_FMC_PFAPR_M2PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M2PFD) & BM_FMC_PFAPR_M2PFD)

/*! @brief Set the M2PFD field to a new value. */
#define BW_FMC_PFAPR_M2PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M2PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M3PFD[19] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M3PFD   (19U)         /*!< Bit position for FMC_PFAPR_M3PFD. */
#define BM_FMC_PFAPR_M3PFD   (0x00080000U) /*!< Bit mask for FMC_PFAPR_M3PFD. */
#define BS_FMC_PFAPR_M3PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M3PFD. */

/*! @brief Read current value of the FMC_PFAPR_M3PFD field. */
#define BR_FMC_PFAPR_M3PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M3PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M3PFD. */
#define BF_FMC_PFAPR_M3PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M3PFD) & BM_FMC_PFAPR_M3PFD)

/*! @brief Set the M3PFD field to a new value. */
#define BW_FMC_PFAPR_M3PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M3PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M4PFD[20] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M4PFD   (20U)         /*!< Bit position for FMC_PFAPR_M4PFD. */
#define BM_FMC_PFAPR_M4PFD   (0x00100000U) /*!< Bit mask for FMC_PFAPR_M4PFD. */
#define BS_FMC_PFAPR_M4PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M4PFD. */

/*! @brief Read current value of the FMC_PFAPR_M4PFD field. */
#define BR_FMC_PFAPR_M4PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M4PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M4PFD. */
#define BF_FMC_PFAPR_M4PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M4PFD) & BM_FMC_PFAPR_M4PFD)

/*! @brief Set the M4PFD field to a new value. */
#define BW_FMC_PFAPR_M4PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M4PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M5PFD[21] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M5PFD   (21U)         /*!< Bit position for FMC_PFAPR_M5PFD. */
#define BM_FMC_PFAPR_M5PFD   (0x00200000U) /*!< Bit mask for FMC_PFAPR_M5PFD. */
#define BS_FMC_PFAPR_M5PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M5PFD. */

/*! @brief Read current value of the FMC_PFAPR_M5PFD field. */
#define BR_FMC_PFAPR_M5PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M5PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M5PFD. */
#define BF_FMC_PFAPR_M5PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M5PFD) & BM_FMC_PFAPR_M5PFD)

/*! @brief Set the M5PFD field to a new value. */
#define BW_FMC_PFAPR_M5PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M5PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M6PFD[22] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M6PFD   (22U)         /*!< Bit position for FMC_PFAPR_M6PFD. */
#define BM_FMC_PFAPR_M6PFD   (0x00400000U) /*!< Bit mask for FMC_PFAPR_M6PFD. */
#define BS_FMC_PFAPR_M6PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M6PFD. */

/*! @brief Read current value of the FMC_PFAPR_M6PFD field. */
#define BR_FMC_PFAPR_M6PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M6PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M6PFD. */
#define BF_FMC_PFAPR_M6PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M6PFD) & BM_FMC_PFAPR_M6PFD)

/*! @brief Set the M6PFD field to a new value. */
#define BW_FMC_PFAPR_M6PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M6PFD) = (v))
/*@}*/

/*!
 * @name Register FMC_PFAPR, field M7PFD[23] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
/*@{*/
#define BP_FMC_PFAPR_M7PFD   (23U)         /*!< Bit position for FMC_PFAPR_M7PFD. */
#define BM_FMC_PFAPR_M7PFD   (0x00800000U) /*!< Bit mask for FMC_PFAPR_M7PFD. */
#define BS_FMC_PFAPR_M7PFD   (1U)          /*!< Bit field size in bits for FMC_PFAPR_M7PFD. */

/*! @brief Read current value of the FMC_PFAPR_M7PFD field. */
#define BR_FMC_PFAPR_M7PFD(x) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M7PFD))

/*! @brief Format value for bitfield FMC_PFAPR_M7PFD. */
#define BF_FMC_PFAPR_M7PFD(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFAPR_M7PFD) & BM_FMC_PFAPR_M7PFD)

/*! @brief Set the M7PFD field to a new value. */
#define BW_FMC_PFAPR_M7PFD(x, v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR(x), BP_FMC_PFAPR_M7PFD) = (v))
/*@}*/

/*******************************************************************************
 * HW_FMC_PFB0CR - Flash Bank 0 Control Register
 ******************************************************************************/

/*!
 * @brief HW_FMC_PFB0CR - Flash Bank 0 Control Register (RW)
 *
 * Reset value: 0x3004001FU
 */
typedef union _hw_fmc_pfb0cr
{
    uint32_t U;
    struct _hw_fmc_pfb0cr_bitfields
    {
        uint32_t B0SEBE : 1;           /*!< [0] Bank 0 Single Entry Buffer Enable */
        uint32_t B0IPE : 1;            /*!< [1] Bank 0 Instruction Prefetch Enable */
        uint32_t B0DPE : 1;            /*!< [2] Bank 0 Data Prefetch Enable */
        uint32_t B0ICE : 1;            /*!< [3] Bank 0 Instruction Cache Enable */
        uint32_t B0DCE : 1;            /*!< [4] Bank 0 Data Cache Enable */
        uint32_t CRC : 3;              /*!< [7:5] Cache Replacement Control */
        uint32_t RESERVED0 : 9;        /*!< [16:8]  */
        uint32_t B0MW : 2;             /*!< [18:17] Bank 0 Memory Width */
        uint32_t S_B_INV : 1;          /*!< [19] Invalidate Prefetch Speculation
                                        * Buffer */
        uint32_t CINV_WAY : 4;         /*!< [23:20] Cache Invalidate Way x */
        uint32_t CLCK_WAY : 4;         /*!< [27:24] Cache Lock Way x */
        uint32_t B0RWSC : 4;           /*!< [31:28] Bank 0 Read Wait State Control */
    } B;
} hw_fmc_pfb0cr_t;

/*!
 * @name Constants and macros for entire FMC_PFB0CR register
 */
/*@{*/
#define HW_FMC_PFB0CR_ADDR(x)    ((x) + 0x4U)

#define HW_FMC_PFB0CR(x)         (*(__IO hw_fmc_pfb0cr_t *) HW_FMC_PFB0CR_ADDR(x))
#define HW_FMC_PFB0CR_RD(x)      (HW_FMC_PFB0CR(x).U)
#define HW_FMC_PFB0CR_WR(x, v)   (HW_FMC_PFB0CR(x).U = (v))
#define HW_FMC_PFB0CR_SET(x, v)  (HW_FMC_PFB0CR_WR(x, HW_FMC_PFB0CR_RD(x) |  (v)))
#define HW_FMC_PFB0CR_CLR(x, v)  (HW_FMC_PFB0CR_WR(x, HW_FMC_PFB0CR_RD(x) & ~(v)))
#define HW_FMC_PFB0CR_TOG(x, v)  (HW_FMC_PFB0CR_WR(x, HW_FMC_PFB0CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_PFB0CR bitfields
 */

/*!
 * @name Register FMC_PFB0CR, field B0SEBE[0] (RW)
 *
 * This bit controls whether the single entry page buffer is enabled in response
 * to flash read accesses. Its operation is independent from bank 1's cache. A
 * high-to-low transition of this enable forces the page buffer to be invalidated.
 *
 * Values:
 * - 0 - Single entry buffer is disabled.
 * - 1 - Single entry buffer is enabled.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0SEBE (0U)          /*!< Bit position for FMC_PFB0CR_B0SEBE. */
#define BM_FMC_PFB0CR_B0SEBE (0x00000001U) /*!< Bit mask for FMC_PFB0CR_B0SEBE. */
#define BS_FMC_PFB0CR_B0SEBE (1U)          /*!< Bit field size in bits for FMC_PFB0CR_B0SEBE. */

/*! @brief Read current value of the FMC_PFB0CR_B0SEBE field. */
#define BR_FMC_PFB0CR_B0SEBE(x) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0SEBE))

/*! @brief Format value for bitfield FMC_PFB0CR_B0SEBE. */
#define BF_FMC_PFB0CR_B0SEBE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_B0SEBE) & BM_FMC_PFB0CR_B0SEBE)

/*! @brief Set the B0SEBE field to a new value. */
#define BW_FMC_PFB0CR_B0SEBE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0SEBE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0IPE[1] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to instruction fetches.
 *
 * Values:
 * - 0 - Do not prefetch in response to instruction fetches.
 * - 1 - Enable prefetches in response to instruction fetches.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0IPE  (1U)          /*!< Bit position for FMC_PFB0CR_B0IPE. */
#define BM_FMC_PFB0CR_B0IPE  (0x00000002U) /*!< Bit mask for FMC_PFB0CR_B0IPE. */
#define BS_FMC_PFB0CR_B0IPE  (1U)          /*!< Bit field size in bits for FMC_PFB0CR_B0IPE. */

/*! @brief Read current value of the FMC_PFB0CR_B0IPE field. */
#define BR_FMC_PFB0CR_B0IPE(x) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0IPE))

/*! @brief Format value for bitfield FMC_PFB0CR_B0IPE. */
#define BF_FMC_PFB0CR_B0IPE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_B0IPE) & BM_FMC_PFB0CR_B0IPE)

/*! @brief Set the B0IPE field to a new value. */
#define BW_FMC_PFB0CR_B0IPE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0IPE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0DPE[2] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to data references.
 *
 * Values:
 * - 0 - Do not prefetch in response to data references.
 * - 1 - Enable prefetches in response to data references.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0DPE  (2U)          /*!< Bit position for FMC_PFB0CR_B0DPE. */
#define BM_FMC_PFB0CR_B0DPE  (0x00000004U) /*!< Bit mask for FMC_PFB0CR_B0DPE. */
#define BS_FMC_PFB0CR_B0DPE  (1U)          /*!< Bit field size in bits for FMC_PFB0CR_B0DPE. */

/*! @brief Read current value of the FMC_PFB0CR_B0DPE field. */
#define BR_FMC_PFB0CR_B0DPE(x) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0DPE))

/*! @brief Format value for bitfield FMC_PFB0CR_B0DPE. */
#define BF_FMC_PFB0CR_B0DPE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_B0DPE) & BM_FMC_PFB0CR_B0DPE)

/*! @brief Set the B0DPE field to a new value. */
#define BW_FMC_PFB0CR_B0DPE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0DPE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0ICE[3] (RW)
 *
 * This bit controls whether instruction fetches are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache instruction fetches.
 * - 1 - Cache instruction fetches.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0ICE  (3U)          /*!< Bit position for FMC_PFB0CR_B0ICE. */
#define BM_FMC_PFB0CR_B0ICE  (0x00000008U) /*!< Bit mask for FMC_PFB0CR_B0ICE. */
#define BS_FMC_PFB0CR_B0ICE  (1U)          /*!< Bit field size in bits for FMC_PFB0CR_B0ICE. */

/*! @brief Read current value of the FMC_PFB0CR_B0ICE field. */
#define BR_FMC_PFB0CR_B0ICE(x) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0ICE))

/*! @brief Format value for bitfield FMC_PFB0CR_B0ICE. */
#define BF_FMC_PFB0CR_B0ICE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_B0ICE) & BM_FMC_PFB0CR_B0ICE)

/*! @brief Set the B0ICE field to a new value. */
#define BW_FMC_PFB0CR_B0ICE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0ICE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0DCE[4] (RW)
 *
 * This bit controls whether data references are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache data references.
 * - 1 - Cache data references.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0DCE  (4U)          /*!< Bit position for FMC_PFB0CR_B0DCE. */
#define BM_FMC_PFB0CR_B0DCE  (0x00000010U) /*!< Bit mask for FMC_PFB0CR_B0DCE. */
#define BS_FMC_PFB0CR_B0DCE  (1U)          /*!< Bit field size in bits for FMC_PFB0CR_B0DCE. */

/*! @brief Read current value of the FMC_PFB0CR_B0DCE field. */
#define BR_FMC_PFB0CR_B0DCE(x) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0DCE))

/*! @brief Format value for bitfield FMC_PFB0CR_B0DCE. */
#define BF_FMC_PFB0CR_B0DCE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_B0DCE) & BM_FMC_PFB0CR_B0DCE)

/*! @brief Set the B0DCE field to a new value. */
#define BW_FMC_PFB0CR_B0DCE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_B0DCE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field CRC[7:5] (RW)
 *
 * This 3-bit field defines the replacement algorithm for accesses that are
 * cached.
 *
 * Values:
 * - 000 - LRU replacement algorithm per set across all four ways
 * - 001 - Reserved
 * - 010 - Independent LRU with ways [0-1] for ifetches, [2-3] for data
 * - 011 - Independent LRU with ways [0-2] for ifetches, [3] for data
 * - 1xx - Reserved
 */
/*@{*/
#define BP_FMC_PFB0CR_CRC    (5U)          /*!< Bit position for FMC_PFB0CR_CRC. */
#define BM_FMC_PFB0CR_CRC    (0x000000E0U) /*!< Bit mask for FMC_PFB0CR_CRC. */
#define BS_FMC_PFB0CR_CRC    (3U)          /*!< Bit field size in bits for FMC_PFB0CR_CRC. */

/*! @brief Read current value of the FMC_PFB0CR_CRC field. */
#define BR_FMC_PFB0CR_CRC(x) (HW_FMC_PFB0CR(x).B.CRC)

/*! @brief Format value for bitfield FMC_PFB0CR_CRC. */
#define BF_FMC_PFB0CR_CRC(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_CRC) & BM_FMC_PFB0CR_CRC)

/*! @brief Set the CRC field to a new value. */
#define BW_FMC_PFB0CR_CRC(x, v) (HW_FMC_PFB0CR_WR(x, (HW_FMC_PFB0CR_RD(x) & ~BM_FMC_PFB0CR_CRC) | BF_FMC_PFB0CR_CRC(v)))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0MW[18:17] (RO)
 *
 * This read-only field defines the width of the bank 0 memory.
 *
 * Values:
 * - 00 - 32 bits
 * - 01 - 64 bits
 * - 10 - 128 bits
 * - 11 - Reserved
 */
/*@{*/
#define BP_FMC_PFB0CR_B0MW   (17U)         /*!< Bit position for FMC_PFB0CR_B0MW. */
#define BM_FMC_PFB0CR_B0MW   (0x00060000U) /*!< Bit mask for FMC_PFB0CR_B0MW. */
#define BS_FMC_PFB0CR_B0MW   (2U)          /*!< Bit field size in bits for FMC_PFB0CR_B0MW. */

/*! @brief Read current value of the FMC_PFB0CR_B0MW field. */
#define BR_FMC_PFB0CR_B0MW(x) (HW_FMC_PFB0CR(x).B.B0MW)
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field S_B_INV[19] (WORZ)
 *
 * This bit determines if the FMC's prefetch speculation buffer and the single
 * entry page buffer are to be invalidated (cleared). When this bit is written,
 * the speculation buffer and single entry buffer are immediately cleared. This bit
 * always reads as zero.
 *
 * Values:
 * - 0 - Speculation buffer and single entry buffer are not affected.
 * - 1 - Invalidate (clear) speculation buffer and single entry buffer.
 */
/*@{*/
#define BP_FMC_PFB0CR_S_B_INV (19U)        /*!< Bit position for FMC_PFB0CR_S_B_INV. */
#define BM_FMC_PFB0CR_S_B_INV (0x00080000U) /*!< Bit mask for FMC_PFB0CR_S_B_INV. */
#define BS_FMC_PFB0CR_S_B_INV (1U)         /*!< Bit field size in bits for FMC_PFB0CR_S_B_INV. */

/*! @brief Format value for bitfield FMC_PFB0CR_S_B_INV. */
#define BF_FMC_PFB0CR_S_B_INV(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_S_B_INV) & BM_FMC_PFB0CR_S_B_INV)

/*! @brief Set the S_B_INV field to a new value. */
#define BW_FMC_PFB0CR_S_B_INV(x, v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR(x), BP_FMC_PFB0CR_S_B_INV) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field CINV_WAY[23:20] (WORZ)
 *
 * These bits determine if the given cache way is to be invalidated (cleared).
 * When a bit within this field is written, the corresponding cache way is
 * immediately invalidated: the way's tag, data, and valid contents are cleared. This
 * field always reads as zero. Cache invalidation takes precedence over locking.
 * The cache is invalidated by system reset. System software is required to
 * maintain memory coherency when any segment of the flash memory is programmed or
 * erased. Accordingly, cache invalidations must occur after a programming or erase
 * event is completed and before the new memory image is accessed. The bit setting
 * definitions are for each bit in the field.
 *
 * Values:
 * - 0 - No cache way invalidation for the corresponding cache
 * - 1 - Invalidate cache way for the corresponding cache: clear the tag, data,
 *     and vld bits of ways selected
 */
/*@{*/
#define BP_FMC_PFB0CR_CINV_WAY (20U)       /*!< Bit position for FMC_PFB0CR_CINV_WAY. */
#define BM_FMC_PFB0CR_CINV_WAY (0x00F00000U) /*!< Bit mask for FMC_PFB0CR_CINV_WAY. */
#define BS_FMC_PFB0CR_CINV_WAY (4U)        /*!< Bit field size in bits for FMC_PFB0CR_CINV_WAY. */

/*! @brief Format value for bitfield FMC_PFB0CR_CINV_WAY. */
#define BF_FMC_PFB0CR_CINV_WAY(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_CINV_WAY) & BM_FMC_PFB0CR_CINV_WAY)

/*! @brief Set the CINV_WAY field to a new value. */
#define BW_FMC_PFB0CR_CINV_WAY(x, v) (HW_FMC_PFB0CR_WR(x, (HW_FMC_PFB0CR_RD(x) & ~BM_FMC_PFB0CR_CINV_WAY) | BF_FMC_PFB0CR_CINV_WAY(v)))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field CLCK_WAY[27:24] (RW)
 *
 * These bits determine if the given cache way is locked such that its contents
 * will not be displaced by future misses. The bit setting definitions are for
 * each bit in the field.
 *
 * Values:
 * - 0 - Cache way is unlocked and may be displaced
 * - 1 - Cache way is locked and its contents are not displaced
 */
/*@{*/
#define BP_FMC_PFB0CR_CLCK_WAY (24U)       /*!< Bit position for FMC_PFB0CR_CLCK_WAY. */
#define BM_FMC_PFB0CR_CLCK_WAY (0x0F000000U) /*!< Bit mask for FMC_PFB0CR_CLCK_WAY. */
#define BS_FMC_PFB0CR_CLCK_WAY (4U)        /*!< Bit field size in bits for FMC_PFB0CR_CLCK_WAY. */

/*! @brief Read current value of the FMC_PFB0CR_CLCK_WAY field. */
#define BR_FMC_PFB0CR_CLCK_WAY(x) (HW_FMC_PFB0CR(x).B.CLCK_WAY)

/*! @brief Format value for bitfield FMC_PFB0CR_CLCK_WAY. */
#define BF_FMC_PFB0CR_CLCK_WAY(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB0CR_CLCK_WAY) & BM_FMC_PFB0CR_CLCK_WAY)

/*! @brief Set the CLCK_WAY field to a new value. */
#define BW_FMC_PFB0CR_CLCK_WAY(x, v) (HW_FMC_PFB0CR_WR(x, (HW_FMC_PFB0CR_RD(x) & ~BM_FMC_PFB0CR_CLCK_WAY) | BF_FMC_PFB0CR_CLCK_WAY(v)))
/*@}*/

/*!
 * @name Register FMC_PFB0CR, field B0RWSC[31:28] (RO)
 *
 * This read-only field defines the number of wait states required to access the
 * bank 0 flash memory. The relationship between the read access time of the
 * flash array (expressed in system clock cycles) and RWSC is defined as: Access
 * time of flash array [system clocks] = RWSC + 1 The FMC automatically calculates
 * this value based on the ratio of the system clock speed to the flash clock
 * speed. For example, when this ratio is 4:1, the field's value is 3h.
 */
/*@{*/
#define BP_FMC_PFB0CR_B0RWSC (28U)         /*!< Bit position for FMC_PFB0CR_B0RWSC. */
#define BM_FMC_PFB0CR_B0RWSC (0xF0000000U) /*!< Bit mask for FMC_PFB0CR_B0RWSC. */
#define BS_FMC_PFB0CR_B0RWSC (4U)          /*!< Bit field size in bits for FMC_PFB0CR_B0RWSC. */

/*! @brief Read current value of the FMC_PFB0CR_B0RWSC field. */
#define BR_FMC_PFB0CR_B0RWSC(x) (HW_FMC_PFB0CR(x).B.B0RWSC)
/*@}*/

/*******************************************************************************
 * HW_FMC_PFB1CR - Flash Bank 1 Control Register
 ******************************************************************************/

/*!
 * @brief HW_FMC_PFB1CR - Flash Bank 1 Control Register (RW)
 *
 * Reset value: 0x3004001FU
 *
 * This register has a format similar to that for PFB0CR, except it controls the
 * operation of flash bank 1, and the "global" cache control fields are empty.
 */
typedef union _hw_fmc_pfb1cr
{
    uint32_t U;
    struct _hw_fmc_pfb1cr_bitfields
    {
        uint32_t B1SEBE : 1;           /*!< [0] Bank 1 Single Entry Buffer Enable */
        uint32_t B1IPE : 1;            /*!< [1] Bank 1 Instruction Prefetch Enable */
        uint32_t B1DPE : 1;            /*!< [2] Bank 1 Data Prefetch Enable */
        uint32_t B1ICE : 1;            /*!< [3] Bank 1 Instruction Cache Enable */
        uint32_t B1DCE : 1;            /*!< [4] Bank 1 Data Cache Enable */
        uint32_t RESERVED0 : 12;       /*!< [16:5]  */
        uint32_t B1MW : 2;             /*!< [18:17] Bank 1 Memory Width */
        uint32_t RESERVED1 : 9;        /*!< [27:19]  */
        uint32_t B1RWSC : 4;           /*!< [31:28] Bank 1 Read Wait State Control */
    } B;
} hw_fmc_pfb1cr_t;

/*!
 * @name Constants and macros for entire FMC_PFB1CR register
 */
/*@{*/
#define HW_FMC_PFB1CR_ADDR(x)    ((x) + 0x8U)

#define HW_FMC_PFB1CR(x)         (*(__IO hw_fmc_pfb1cr_t *) HW_FMC_PFB1CR_ADDR(x))
#define HW_FMC_PFB1CR_RD(x)      (HW_FMC_PFB1CR(x).U)
#define HW_FMC_PFB1CR_WR(x, v)   (HW_FMC_PFB1CR(x).U = (v))
#define HW_FMC_PFB1CR_SET(x, v)  (HW_FMC_PFB1CR_WR(x, HW_FMC_PFB1CR_RD(x) |  (v)))
#define HW_FMC_PFB1CR_CLR(x, v)  (HW_FMC_PFB1CR_WR(x, HW_FMC_PFB1CR_RD(x) & ~(v)))
#define HW_FMC_PFB1CR_TOG(x, v)  (HW_FMC_PFB1CR_WR(x, HW_FMC_PFB1CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_PFB1CR bitfields
 */

/*!
 * @name Register FMC_PFB1CR, field B1SEBE[0] (RW)
 *
 * This bit controls whether the single entry buffer is enabled in response to
 * flash read accesses. Its operation is independent from bank 0's cache. A
 * high-to-low transition of this enable forces the page buffer to be invalidated.
 *
 * Values:
 * - 0 - Single entry buffer is disabled.
 * - 1 - Single entry buffer is enabled.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1SEBE (0U)          /*!< Bit position for FMC_PFB1CR_B1SEBE. */
#define BM_FMC_PFB1CR_B1SEBE (0x00000001U) /*!< Bit mask for FMC_PFB1CR_B1SEBE. */
#define BS_FMC_PFB1CR_B1SEBE (1U)          /*!< Bit field size in bits for FMC_PFB1CR_B1SEBE. */

/*! @brief Read current value of the FMC_PFB1CR_B1SEBE field. */
#define BR_FMC_PFB1CR_B1SEBE(x) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1SEBE))

/*! @brief Format value for bitfield FMC_PFB1CR_B1SEBE. */
#define BF_FMC_PFB1CR_B1SEBE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB1CR_B1SEBE) & BM_FMC_PFB1CR_B1SEBE)

/*! @brief Set the B1SEBE field to a new value. */
#define BW_FMC_PFB1CR_B1SEBE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1SEBE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1IPE[1] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to instruction fetches.
 *
 * Values:
 * - 0 - Do not prefetch in response to instruction fetches.
 * - 1 - Enable prefetches in response to instruction fetches.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1IPE  (1U)          /*!< Bit position for FMC_PFB1CR_B1IPE. */
#define BM_FMC_PFB1CR_B1IPE  (0x00000002U) /*!< Bit mask for FMC_PFB1CR_B1IPE. */
#define BS_FMC_PFB1CR_B1IPE  (1U)          /*!< Bit field size in bits for FMC_PFB1CR_B1IPE. */

/*! @brief Read current value of the FMC_PFB1CR_B1IPE field. */
#define BR_FMC_PFB1CR_B1IPE(x) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1IPE))

/*! @brief Format value for bitfield FMC_PFB1CR_B1IPE. */
#define BF_FMC_PFB1CR_B1IPE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB1CR_B1IPE) & BM_FMC_PFB1CR_B1IPE)

/*! @brief Set the B1IPE field to a new value. */
#define BW_FMC_PFB1CR_B1IPE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1IPE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1DPE[2] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to data references.
 *
 * Values:
 * - 0 - Do not prefetch in response to data references.
 * - 1 - Enable prefetches in response to data references.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1DPE  (2U)          /*!< Bit position for FMC_PFB1CR_B1DPE. */
#define BM_FMC_PFB1CR_B1DPE  (0x00000004U) /*!< Bit mask for FMC_PFB1CR_B1DPE. */
#define BS_FMC_PFB1CR_B1DPE  (1U)          /*!< Bit field size in bits for FMC_PFB1CR_B1DPE. */

/*! @brief Read current value of the FMC_PFB1CR_B1DPE field. */
#define BR_FMC_PFB1CR_B1DPE(x) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1DPE))

/*! @brief Format value for bitfield FMC_PFB1CR_B1DPE. */
#define BF_FMC_PFB1CR_B1DPE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB1CR_B1DPE) & BM_FMC_PFB1CR_B1DPE)

/*! @brief Set the B1DPE field to a new value. */
#define BW_FMC_PFB1CR_B1DPE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1DPE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1ICE[3] (RW)
 *
 * This bit controls whether instruction fetches are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache instruction fetches.
 * - 1 - Cache instruction fetches.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1ICE  (3U)          /*!< Bit position for FMC_PFB1CR_B1ICE. */
#define BM_FMC_PFB1CR_B1ICE  (0x00000008U) /*!< Bit mask for FMC_PFB1CR_B1ICE. */
#define BS_FMC_PFB1CR_B1ICE  (1U)          /*!< Bit field size in bits for FMC_PFB1CR_B1ICE. */

/*! @brief Read current value of the FMC_PFB1CR_B1ICE field. */
#define BR_FMC_PFB1CR_B1ICE(x) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1ICE))

/*! @brief Format value for bitfield FMC_PFB1CR_B1ICE. */
#define BF_FMC_PFB1CR_B1ICE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB1CR_B1ICE) & BM_FMC_PFB1CR_B1ICE)

/*! @brief Set the B1ICE field to a new value. */
#define BW_FMC_PFB1CR_B1ICE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1ICE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1DCE[4] (RW)
 *
 * This bit controls whether data references are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache data references.
 * - 1 - Cache data references.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1DCE  (4U)          /*!< Bit position for FMC_PFB1CR_B1DCE. */
#define BM_FMC_PFB1CR_B1DCE  (0x00000010U) /*!< Bit mask for FMC_PFB1CR_B1DCE. */
#define BS_FMC_PFB1CR_B1DCE  (1U)          /*!< Bit field size in bits for FMC_PFB1CR_B1DCE. */

/*! @brief Read current value of the FMC_PFB1CR_B1DCE field. */
#define BR_FMC_PFB1CR_B1DCE(x) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1DCE))

/*! @brief Format value for bitfield FMC_PFB1CR_B1DCE. */
#define BF_FMC_PFB1CR_B1DCE(v) ((uint32_t)((uint32_t)(v) << BP_FMC_PFB1CR_B1DCE) & BM_FMC_PFB1CR_B1DCE)

/*! @brief Set the B1DCE field to a new value. */
#define BW_FMC_PFB1CR_B1DCE(x, v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR(x), BP_FMC_PFB1CR_B1DCE) = (v))
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1MW[18:17] (RO)
 *
 * This read-only field defines the width of the bank 1 memory.
 *
 * Values:
 * - 00 - 32 bits
 * - 01 - 64 bits
 * - 10 - 128 bits
 * - 11 - Reserved
 */
/*@{*/
#define BP_FMC_PFB1CR_B1MW   (17U)         /*!< Bit position for FMC_PFB1CR_B1MW. */
#define BM_FMC_PFB1CR_B1MW   (0x00060000U) /*!< Bit mask for FMC_PFB1CR_B1MW. */
#define BS_FMC_PFB1CR_B1MW   (2U)          /*!< Bit field size in bits for FMC_PFB1CR_B1MW. */

/*! @brief Read current value of the FMC_PFB1CR_B1MW field. */
#define BR_FMC_PFB1CR_B1MW(x) (HW_FMC_PFB1CR(x).B.B1MW)
/*@}*/

/*!
 * @name Register FMC_PFB1CR, field B1RWSC[31:28] (RO)
 *
 * This read-only field defines the number of wait states required to access the
 * bank 1 flash memory. The relationship between the read access time of the
 * flash array (expressed in system clock cycles) and RWSC is defined as: Access
 * time of flash array [system clocks] = RWSC + 1 The FMC automatically calculates
 * this value based on the ratio of the system clock speed to the flash clock
 * speed. For example, when this ratio is 4:1, the field's value is 3h.
 */
/*@{*/
#define BP_FMC_PFB1CR_B1RWSC (28U)         /*!< Bit position for FMC_PFB1CR_B1RWSC. */
#define BM_FMC_PFB1CR_B1RWSC (0xF0000000U) /*!< Bit mask for FMC_PFB1CR_B1RWSC. */
#define BS_FMC_PFB1CR_B1RWSC (4U)          /*!< Bit field size in bits for FMC_PFB1CR_B1RWSC. */

/*! @brief Read current value of the FMC_PFB1CR_B1RWSC field. */
#define BR_FMC_PFB1CR_B1RWSC(x) (HW_FMC_PFB1CR(x).B.B1RWSC)
/*@}*/

/*******************************************************************************
 * HW_FMC_TAGVDW0Sn - Cache Tag Storage
 ******************************************************************************/

/*!
 * @brief HW_FMC_TAGVDW0Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw0sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw0sn_bitfields
    {
        uint32_t valid : 1;            /*!< [0] 1-bit valid for cache entry */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t tag : 14;             /*!< [18:5] 14-bit tag for cache entry */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_fmc_tagvdw0sn_t;

/*!
 * @name Constants and macros for entire FMC_TAGVDW0Sn register
 */
/*@{*/
#define HW_FMC_TAGVDW0Sn_COUNT (4U)

#define HW_FMC_TAGVDW0Sn_ADDR(x, n) ((x) + 0x100U + (0x4U * (n)))

#define HW_FMC_TAGVDW0Sn(x, n)   (*(__IO hw_fmc_tagvdw0sn_t *) HW_FMC_TAGVDW0Sn_ADDR(x, n))
#define HW_FMC_TAGVDW0Sn_RD(x, n) (HW_FMC_TAGVDW0Sn(x, n).U)
#define HW_FMC_TAGVDW0Sn_WR(x, n, v) (HW_FMC_TAGVDW0Sn(x, n).U = (v))
#define HW_FMC_TAGVDW0Sn_SET(x, n, v) (HW_FMC_TAGVDW0Sn_WR(x, n, HW_FMC_TAGVDW0Sn_RD(x, n) |  (v)))
#define HW_FMC_TAGVDW0Sn_CLR(x, n, v) (HW_FMC_TAGVDW0Sn_WR(x, n, HW_FMC_TAGVDW0Sn_RD(x, n) & ~(v)))
#define HW_FMC_TAGVDW0Sn_TOG(x, n, v) (HW_FMC_TAGVDW0Sn_WR(x, n, HW_FMC_TAGVDW0Sn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_TAGVDW0Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW0Sn, field valid[0] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW0Sn_valid (0U)        /*!< Bit position for FMC_TAGVDW0Sn_valid. */
#define BM_FMC_TAGVDW0Sn_valid (0x00000001U) /*!< Bit mask for FMC_TAGVDW0Sn_valid. */
#define BS_FMC_TAGVDW0Sn_valid (1U)        /*!< Bit field size in bits for FMC_TAGVDW0Sn_valid. */

/*! @brief Read current value of the FMC_TAGVDW0Sn_valid field. */
#define BR_FMC_TAGVDW0Sn_valid(x, n) (BITBAND_ACCESS32(HW_FMC_TAGVDW0Sn_ADDR(x, n), BP_FMC_TAGVDW0Sn_valid))

/*! @brief Format value for bitfield FMC_TAGVDW0Sn_valid. */
#define BF_FMC_TAGVDW0Sn_valid(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW0Sn_valid) & BM_FMC_TAGVDW0Sn_valid)

/*! @brief Set the valid field to a new value. */
#define BW_FMC_TAGVDW0Sn_valid(x, n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW0Sn_ADDR(x, n), BP_FMC_TAGVDW0Sn_valid) = (v))
/*@}*/

/*!
 * @name Register FMC_TAGVDW0Sn, field tag[18:5] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW0Sn_tag (5U)          /*!< Bit position for FMC_TAGVDW0Sn_tag. */
#define BM_FMC_TAGVDW0Sn_tag (0x0007FFE0U) /*!< Bit mask for FMC_TAGVDW0Sn_tag. */
#define BS_FMC_TAGVDW0Sn_tag (14U)         /*!< Bit field size in bits for FMC_TAGVDW0Sn_tag. */

/*! @brief Read current value of the FMC_TAGVDW0Sn_tag field. */
#define BR_FMC_TAGVDW0Sn_tag(x, n) (HW_FMC_TAGVDW0Sn(x, n).B.tag)

/*! @brief Format value for bitfield FMC_TAGVDW0Sn_tag. */
#define BF_FMC_TAGVDW0Sn_tag(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW0Sn_tag) & BM_FMC_TAGVDW0Sn_tag)

/*! @brief Set the tag field to a new value. */
#define BW_FMC_TAGVDW0Sn_tag(x, n, v) (HW_FMC_TAGVDW0Sn_WR(x, n, (HW_FMC_TAGVDW0Sn_RD(x, n) & ~BM_FMC_TAGVDW0Sn_tag) | BF_FMC_TAGVDW0Sn_tag(v)))
/*@}*/

/*******************************************************************************
 * HW_FMC_TAGVDW1Sn - Cache Tag Storage
 ******************************************************************************/

/*!
 * @brief HW_FMC_TAGVDW1Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw1sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw1sn_bitfields
    {
        uint32_t valid : 1;            /*!< [0] 1-bit valid for cache entry */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t tag : 14;             /*!< [18:5] 14-bit tag for cache entry */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_fmc_tagvdw1sn_t;

/*!
 * @name Constants and macros for entire FMC_TAGVDW1Sn register
 */
/*@{*/
#define HW_FMC_TAGVDW1Sn_COUNT (4U)

#define HW_FMC_TAGVDW1Sn_ADDR(x, n) ((x) + 0x110U + (0x4U * (n)))

#define HW_FMC_TAGVDW1Sn(x, n)   (*(__IO hw_fmc_tagvdw1sn_t *) HW_FMC_TAGVDW1Sn_ADDR(x, n))
#define HW_FMC_TAGVDW1Sn_RD(x, n) (HW_FMC_TAGVDW1Sn(x, n).U)
#define HW_FMC_TAGVDW1Sn_WR(x, n, v) (HW_FMC_TAGVDW1Sn(x, n).U = (v))
#define HW_FMC_TAGVDW1Sn_SET(x, n, v) (HW_FMC_TAGVDW1Sn_WR(x, n, HW_FMC_TAGVDW1Sn_RD(x, n) |  (v)))
#define HW_FMC_TAGVDW1Sn_CLR(x, n, v) (HW_FMC_TAGVDW1Sn_WR(x, n, HW_FMC_TAGVDW1Sn_RD(x, n) & ~(v)))
#define HW_FMC_TAGVDW1Sn_TOG(x, n, v) (HW_FMC_TAGVDW1Sn_WR(x, n, HW_FMC_TAGVDW1Sn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_TAGVDW1Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW1Sn, field valid[0] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW1Sn_valid (0U)        /*!< Bit position for FMC_TAGVDW1Sn_valid. */
#define BM_FMC_TAGVDW1Sn_valid (0x00000001U) /*!< Bit mask for FMC_TAGVDW1Sn_valid. */
#define BS_FMC_TAGVDW1Sn_valid (1U)        /*!< Bit field size in bits for FMC_TAGVDW1Sn_valid. */

/*! @brief Read current value of the FMC_TAGVDW1Sn_valid field. */
#define BR_FMC_TAGVDW1Sn_valid(x, n) (BITBAND_ACCESS32(HW_FMC_TAGVDW1Sn_ADDR(x, n), BP_FMC_TAGVDW1Sn_valid))

/*! @brief Format value for bitfield FMC_TAGVDW1Sn_valid. */
#define BF_FMC_TAGVDW1Sn_valid(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW1Sn_valid) & BM_FMC_TAGVDW1Sn_valid)

/*! @brief Set the valid field to a new value. */
#define BW_FMC_TAGVDW1Sn_valid(x, n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW1Sn_ADDR(x, n), BP_FMC_TAGVDW1Sn_valid) = (v))
/*@}*/

/*!
 * @name Register FMC_TAGVDW1Sn, field tag[18:5] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW1Sn_tag (5U)          /*!< Bit position for FMC_TAGVDW1Sn_tag. */
#define BM_FMC_TAGVDW1Sn_tag (0x0007FFE0U) /*!< Bit mask for FMC_TAGVDW1Sn_tag. */
#define BS_FMC_TAGVDW1Sn_tag (14U)         /*!< Bit field size in bits for FMC_TAGVDW1Sn_tag. */

/*! @brief Read current value of the FMC_TAGVDW1Sn_tag field. */
#define BR_FMC_TAGVDW1Sn_tag(x, n) (HW_FMC_TAGVDW1Sn(x, n).B.tag)

/*! @brief Format value for bitfield FMC_TAGVDW1Sn_tag. */
#define BF_FMC_TAGVDW1Sn_tag(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW1Sn_tag) & BM_FMC_TAGVDW1Sn_tag)

/*! @brief Set the tag field to a new value. */
#define BW_FMC_TAGVDW1Sn_tag(x, n, v) (HW_FMC_TAGVDW1Sn_WR(x, n, (HW_FMC_TAGVDW1Sn_RD(x, n) & ~BM_FMC_TAGVDW1Sn_tag) | BF_FMC_TAGVDW1Sn_tag(v)))
/*@}*/

/*******************************************************************************
 * HW_FMC_TAGVDW2Sn - Cache Tag Storage
 ******************************************************************************/

/*!
 * @brief HW_FMC_TAGVDW2Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw2sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw2sn_bitfields
    {
        uint32_t valid : 1;            /*!< [0] 1-bit valid for cache entry */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t tag : 14;             /*!< [18:5] 14-bit tag for cache entry */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_fmc_tagvdw2sn_t;

/*!
 * @name Constants and macros for entire FMC_TAGVDW2Sn register
 */
/*@{*/
#define HW_FMC_TAGVDW2Sn_COUNT (4U)

#define HW_FMC_TAGVDW2Sn_ADDR(x, n) ((x) + 0x120U + (0x4U * (n)))

#define HW_FMC_TAGVDW2Sn(x, n)   (*(__IO hw_fmc_tagvdw2sn_t *) HW_FMC_TAGVDW2Sn_ADDR(x, n))
#define HW_FMC_TAGVDW2Sn_RD(x, n) (HW_FMC_TAGVDW2Sn(x, n).U)
#define HW_FMC_TAGVDW2Sn_WR(x, n, v) (HW_FMC_TAGVDW2Sn(x, n).U = (v))
#define HW_FMC_TAGVDW2Sn_SET(x, n, v) (HW_FMC_TAGVDW2Sn_WR(x, n, HW_FMC_TAGVDW2Sn_RD(x, n) |  (v)))
#define HW_FMC_TAGVDW2Sn_CLR(x, n, v) (HW_FMC_TAGVDW2Sn_WR(x, n, HW_FMC_TAGVDW2Sn_RD(x, n) & ~(v)))
#define HW_FMC_TAGVDW2Sn_TOG(x, n, v) (HW_FMC_TAGVDW2Sn_WR(x, n, HW_FMC_TAGVDW2Sn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_TAGVDW2Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW2Sn, field valid[0] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW2Sn_valid (0U)        /*!< Bit position for FMC_TAGVDW2Sn_valid. */
#define BM_FMC_TAGVDW2Sn_valid (0x00000001U) /*!< Bit mask for FMC_TAGVDW2Sn_valid. */
#define BS_FMC_TAGVDW2Sn_valid (1U)        /*!< Bit field size in bits for FMC_TAGVDW2Sn_valid. */

/*! @brief Read current value of the FMC_TAGVDW2Sn_valid field. */
#define BR_FMC_TAGVDW2Sn_valid(x, n) (BITBAND_ACCESS32(HW_FMC_TAGVDW2Sn_ADDR(x, n), BP_FMC_TAGVDW2Sn_valid))

/*! @brief Format value for bitfield FMC_TAGVDW2Sn_valid. */
#define BF_FMC_TAGVDW2Sn_valid(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW2Sn_valid) & BM_FMC_TAGVDW2Sn_valid)

/*! @brief Set the valid field to a new value. */
#define BW_FMC_TAGVDW2Sn_valid(x, n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW2Sn_ADDR(x, n), BP_FMC_TAGVDW2Sn_valid) = (v))
/*@}*/

/*!
 * @name Register FMC_TAGVDW2Sn, field tag[18:5] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW2Sn_tag (5U)          /*!< Bit position for FMC_TAGVDW2Sn_tag. */
#define BM_FMC_TAGVDW2Sn_tag (0x0007FFE0U) /*!< Bit mask for FMC_TAGVDW2Sn_tag. */
#define BS_FMC_TAGVDW2Sn_tag (14U)         /*!< Bit field size in bits for FMC_TAGVDW2Sn_tag. */

/*! @brief Read current value of the FMC_TAGVDW2Sn_tag field. */
#define BR_FMC_TAGVDW2Sn_tag(x, n) (HW_FMC_TAGVDW2Sn(x, n).B.tag)

/*! @brief Format value for bitfield FMC_TAGVDW2Sn_tag. */
#define BF_FMC_TAGVDW2Sn_tag(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW2Sn_tag) & BM_FMC_TAGVDW2Sn_tag)

/*! @brief Set the tag field to a new value. */
#define BW_FMC_TAGVDW2Sn_tag(x, n, v) (HW_FMC_TAGVDW2Sn_WR(x, n, (HW_FMC_TAGVDW2Sn_RD(x, n) & ~BM_FMC_TAGVDW2Sn_tag) | BF_FMC_TAGVDW2Sn_tag(v)))
/*@}*/

/*******************************************************************************
 * HW_FMC_TAGVDW3Sn - Cache Tag Storage
 ******************************************************************************/

/*!
 * @brief HW_FMC_TAGVDW3Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw3sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw3sn_bitfields
    {
        uint32_t valid : 1;            /*!< [0] 1-bit valid for cache entry */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t tag : 14;             /*!< [18:5] 14-bit tag for cache entry */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_fmc_tagvdw3sn_t;

/*!
 * @name Constants and macros for entire FMC_TAGVDW3Sn register
 */
/*@{*/
#define HW_FMC_TAGVDW3Sn_COUNT (4U)

#define HW_FMC_TAGVDW3Sn_ADDR(x, n) ((x) + 0x130U + (0x4U * (n)))

#define HW_FMC_TAGVDW3Sn(x, n)   (*(__IO hw_fmc_tagvdw3sn_t *) HW_FMC_TAGVDW3Sn_ADDR(x, n))
#define HW_FMC_TAGVDW3Sn_RD(x, n) (HW_FMC_TAGVDW3Sn(x, n).U)
#define HW_FMC_TAGVDW3Sn_WR(x, n, v) (HW_FMC_TAGVDW3Sn(x, n).U = (v))
#define HW_FMC_TAGVDW3Sn_SET(x, n, v) (HW_FMC_TAGVDW3Sn_WR(x, n, HW_FMC_TAGVDW3Sn_RD(x, n) |  (v)))
#define HW_FMC_TAGVDW3Sn_CLR(x, n, v) (HW_FMC_TAGVDW3Sn_WR(x, n, HW_FMC_TAGVDW3Sn_RD(x, n) & ~(v)))
#define HW_FMC_TAGVDW3Sn_TOG(x, n, v) (HW_FMC_TAGVDW3Sn_WR(x, n, HW_FMC_TAGVDW3Sn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_TAGVDW3Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW3Sn, field valid[0] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW3Sn_valid (0U)        /*!< Bit position for FMC_TAGVDW3Sn_valid. */
#define BM_FMC_TAGVDW3Sn_valid (0x00000001U) /*!< Bit mask for FMC_TAGVDW3Sn_valid. */
#define BS_FMC_TAGVDW3Sn_valid (1U)        /*!< Bit field size in bits for FMC_TAGVDW3Sn_valid. */

/*! @brief Read current value of the FMC_TAGVDW3Sn_valid field. */
#define BR_FMC_TAGVDW3Sn_valid(x, n) (BITBAND_ACCESS32(HW_FMC_TAGVDW3Sn_ADDR(x, n), BP_FMC_TAGVDW3Sn_valid))

/*! @brief Format value for bitfield FMC_TAGVDW3Sn_valid. */
#define BF_FMC_TAGVDW3Sn_valid(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW3Sn_valid) & BM_FMC_TAGVDW3Sn_valid)

/*! @brief Set the valid field to a new value. */
#define BW_FMC_TAGVDW3Sn_valid(x, n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW3Sn_ADDR(x, n), BP_FMC_TAGVDW3Sn_valid) = (v))
/*@}*/

/*!
 * @name Register FMC_TAGVDW3Sn, field tag[18:5] (RW)
 */
/*@{*/
#define BP_FMC_TAGVDW3Sn_tag (5U)          /*!< Bit position for FMC_TAGVDW3Sn_tag. */
#define BM_FMC_TAGVDW3Sn_tag (0x0007FFE0U) /*!< Bit mask for FMC_TAGVDW3Sn_tag. */
#define BS_FMC_TAGVDW3Sn_tag (14U)         /*!< Bit field size in bits for FMC_TAGVDW3Sn_tag. */

/*! @brief Read current value of the FMC_TAGVDW3Sn_tag field. */
#define BR_FMC_TAGVDW3Sn_tag(x, n) (HW_FMC_TAGVDW3Sn(x, n).B.tag)

/*! @brief Format value for bitfield FMC_TAGVDW3Sn_tag. */
#define BF_FMC_TAGVDW3Sn_tag(v) ((uint32_t)((uint32_t)(v) << BP_FMC_TAGVDW3Sn_tag) & BM_FMC_TAGVDW3Sn_tag)

/*! @brief Set the tag field to a new value. */
#define BW_FMC_TAGVDW3Sn_tag(x, n, v) (HW_FMC_TAGVDW3Sn_WR(x, n, (HW_FMC_TAGVDW3Sn_RD(x, n) & ~BM_FMC_TAGVDW3Sn_tag) | BF_FMC_TAGVDW3Sn_tag(v)))
/*@}*/

/*******************************************************************************
 * HW_FMC_DATAW0SnU - Cache Data Storage (upper word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW0SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw0snu
{
    uint32_t U;
    struct _hw_fmc_dataw0snu_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [63:32] of data entry */
    } B;
} hw_fmc_dataw0snu_t;

/*!
 * @name Constants and macros for entire FMC_DATAW0SnU register
 */
/*@{*/
#define HW_FMC_DATAW0SnU_COUNT (4U)

#define HW_FMC_DATAW0SnU_ADDR(x, n) ((x) + 0x200U + (0x8U * (n)))

#define HW_FMC_DATAW0SnU(x, n)   (*(__IO hw_fmc_dataw0snu_t *) HW_FMC_DATAW0SnU_ADDR(x, n))
#define HW_FMC_DATAW0SnU_RD(x, n) (HW_FMC_DATAW0SnU(x, n).U)
#define HW_FMC_DATAW0SnU_WR(x, n, v) (HW_FMC_DATAW0SnU(x, n).U = (v))
#define HW_FMC_DATAW0SnU_SET(x, n, v) (HW_FMC_DATAW0SnU_WR(x, n, HW_FMC_DATAW0SnU_RD(x, n) |  (v)))
#define HW_FMC_DATAW0SnU_CLR(x, n, v) (HW_FMC_DATAW0SnU_WR(x, n, HW_FMC_DATAW0SnU_RD(x, n) & ~(v)))
#define HW_FMC_DATAW0SnU_TOG(x, n, v) (HW_FMC_DATAW0SnU_WR(x, n, HW_FMC_DATAW0SnU_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW0SnU bitfields
 */

/*!
 * @name Register FMC_DATAW0SnU, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW0SnU_data (0U)         /*!< Bit position for FMC_DATAW0SnU_data. */
#define BM_FMC_DATAW0SnU_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW0SnU_data. */
#define BS_FMC_DATAW0SnU_data (32U)        /*!< Bit field size in bits for FMC_DATAW0SnU_data. */

/*! @brief Read current value of the FMC_DATAW0SnU_data field. */
#define BR_FMC_DATAW0SnU_data(x, n) (HW_FMC_DATAW0SnU(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW0SnU_data. */
#define BF_FMC_DATAW0SnU_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW0SnU_data) & BM_FMC_DATAW0SnU_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW0SnU_data(x, n, v) (HW_FMC_DATAW0SnU_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_FMC_DATAW0SnL - Cache Data Storage (lower word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW0SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw0snl
{
    uint32_t U;
    struct _hw_fmc_dataw0snl_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [31:0] of data entry */
    } B;
} hw_fmc_dataw0snl_t;

/*!
 * @name Constants and macros for entire FMC_DATAW0SnL register
 */
/*@{*/
#define HW_FMC_DATAW0SnL_COUNT (4U)

#define HW_FMC_DATAW0SnL_ADDR(x, n) ((x) + 0x204U + (0x8U * (n)))

#define HW_FMC_DATAW0SnL(x, n)   (*(__IO hw_fmc_dataw0snl_t *) HW_FMC_DATAW0SnL_ADDR(x, n))
#define HW_FMC_DATAW0SnL_RD(x, n) (HW_FMC_DATAW0SnL(x, n).U)
#define HW_FMC_DATAW0SnL_WR(x, n, v) (HW_FMC_DATAW0SnL(x, n).U = (v))
#define HW_FMC_DATAW0SnL_SET(x, n, v) (HW_FMC_DATAW0SnL_WR(x, n, HW_FMC_DATAW0SnL_RD(x, n) |  (v)))
#define HW_FMC_DATAW0SnL_CLR(x, n, v) (HW_FMC_DATAW0SnL_WR(x, n, HW_FMC_DATAW0SnL_RD(x, n) & ~(v)))
#define HW_FMC_DATAW0SnL_TOG(x, n, v) (HW_FMC_DATAW0SnL_WR(x, n, HW_FMC_DATAW0SnL_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW0SnL bitfields
 */

/*!
 * @name Register FMC_DATAW0SnL, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW0SnL_data (0U)         /*!< Bit position for FMC_DATAW0SnL_data. */
#define BM_FMC_DATAW0SnL_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW0SnL_data. */
#define BS_FMC_DATAW0SnL_data (32U)        /*!< Bit field size in bits for FMC_DATAW0SnL_data. */

/*! @brief Read current value of the FMC_DATAW0SnL_data field. */
#define BR_FMC_DATAW0SnL_data(x, n) (HW_FMC_DATAW0SnL(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW0SnL_data. */
#define BF_FMC_DATAW0SnL_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW0SnL_data) & BM_FMC_DATAW0SnL_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW0SnL_data(x, n, v) (HW_FMC_DATAW0SnL_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_FMC_DATAW1SnU - Cache Data Storage (upper word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW1SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw1snu
{
    uint32_t U;
    struct _hw_fmc_dataw1snu_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [63:32] of data entry */
    } B;
} hw_fmc_dataw1snu_t;

/*!
 * @name Constants and macros for entire FMC_DATAW1SnU register
 */
/*@{*/
#define HW_FMC_DATAW1SnU_COUNT (4U)

#define HW_FMC_DATAW1SnU_ADDR(x, n) ((x) + 0x220U + (0x8U * (n)))

#define HW_FMC_DATAW1SnU(x, n)   (*(__IO hw_fmc_dataw1snu_t *) HW_FMC_DATAW1SnU_ADDR(x, n))
#define HW_FMC_DATAW1SnU_RD(x, n) (HW_FMC_DATAW1SnU(x, n).U)
#define HW_FMC_DATAW1SnU_WR(x, n, v) (HW_FMC_DATAW1SnU(x, n).U = (v))
#define HW_FMC_DATAW1SnU_SET(x, n, v) (HW_FMC_DATAW1SnU_WR(x, n, HW_FMC_DATAW1SnU_RD(x, n) |  (v)))
#define HW_FMC_DATAW1SnU_CLR(x, n, v) (HW_FMC_DATAW1SnU_WR(x, n, HW_FMC_DATAW1SnU_RD(x, n) & ~(v)))
#define HW_FMC_DATAW1SnU_TOG(x, n, v) (HW_FMC_DATAW1SnU_WR(x, n, HW_FMC_DATAW1SnU_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW1SnU bitfields
 */

/*!
 * @name Register FMC_DATAW1SnU, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW1SnU_data (0U)         /*!< Bit position for FMC_DATAW1SnU_data. */
#define BM_FMC_DATAW1SnU_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW1SnU_data. */
#define BS_FMC_DATAW1SnU_data (32U)        /*!< Bit field size in bits for FMC_DATAW1SnU_data. */

/*! @brief Read current value of the FMC_DATAW1SnU_data field. */
#define BR_FMC_DATAW1SnU_data(x, n) (HW_FMC_DATAW1SnU(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW1SnU_data. */
#define BF_FMC_DATAW1SnU_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW1SnU_data) & BM_FMC_DATAW1SnU_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW1SnU_data(x, n, v) (HW_FMC_DATAW1SnU_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_FMC_DATAW1SnL - Cache Data Storage (lower word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW1SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw1snl
{
    uint32_t U;
    struct _hw_fmc_dataw1snl_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [31:0] of data entry */
    } B;
} hw_fmc_dataw1snl_t;

/*!
 * @name Constants and macros for entire FMC_DATAW1SnL register
 */
/*@{*/
#define HW_FMC_DATAW1SnL_COUNT (4U)

#define HW_FMC_DATAW1SnL_ADDR(x, n) ((x) + 0x224U + (0x8U * (n)))

#define HW_FMC_DATAW1SnL(x, n)   (*(__IO hw_fmc_dataw1snl_t *) HW_FMC_DATAW1SnL_ADDR(x, n))
#define HW_FMC_DATAW1SnL_RD(x, n) (HW_FMC_DATAW1SnL(x, n).U)
#define HW_FMC_DATAW1SnL_WR(x, n, v) (HW_FMC_DATAW1SnL(x, n).U = (v))
#define HW_FMC_DATAW1SnL_SET(x, n, v) (HW_FMC_DATAW1SnL_WR(x, n, HW_FMC_DATAW1SnL_RD(x, n) |  (v)))
#define HW_FMC_DATAW1SnL_CLR(x, n, v) (HW_FMC_DATAW1SnL_WR(x, n, HW_FMC_DATAW1SnL_RD(x, n) & ~(v)))
#define HW_FMC_DATAW1SnL_TOG(x, n, v) (HW_FMC_DATAW1SnL_WR(x, n, HW_FMC_DATAW1SnL_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW1SnL bitfields
 */

/*!
 * @name Register FMC_DATAW1SnL, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW1SnL_data (0U)         /*!< Bit position for FMC_DATAW1SnL_data. */
#define BM_FMC_DATAW1SnL_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW1SnL_data. */
#define BS_FMC_DATAW1SnL_data (32U)        /*!< Bit field size in bits for FMC_DATAW1SnL_data. */

/*! @brief Read current value of the FMC_DATAW1SnL_data field. */
#define BR_FMC_DATAW1SnL_data(x, n) (HW_FMC_DATAW1SnL(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW1SnL_data. */
#define BF_FMC_DATAW1SnL_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW1SnL_data) & BM_FMC_DATAW1SnL_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW1SnL_data(x, n, v) (HW_FMC_DATAW1SnL_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_FMC_DATAW2SnU - Cache Data Storage (upper word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW2SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw2snu
{
    uint32_t U;
    struct _hw_fmc_dataw2snu_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [63:32] of data entry */
    } B;
} hw_fmc_dataw2snu_t;

/*!
 * @name Constants and macros for entire FMC_DATAW2SnU register
 */
/*@{*/
#define HW_FMC_DATAW2SnU_COUNT (4U)

#define HW_FMC_DATAW2SnU_ADDR(x, n) ((x) + 0x240U + (0x8U * (n)))

#define HW_FMC_DATAW2SnU(x, n)   (*(__IO hw_fmc_dataw2snu_t *) HW_FMC_DATAW2SnU_ADDR(x, n))
#define HW_FMC_DATAW2SnU_RD(x, n) (HW_FMC_DATAW2SnU(x, n).U)
#define HW_FMC_DATAW2SnU_WR(x, n, v) (HW_FMC_DATAW2SnU(x, n).U = (v))
#define HW_FMC_DATAW2SnU_SET(x, n, v) (HW_FMC_DATAW2SnU_WR(x, n, HW_FMC_DATAW2SnU_RD(x, n) |  (v)))
#define HW_FMC_DATAW2SnU_CLR(x, n, v) (HW_FMC_DATAW2SnU_WR(x, n, HW_FMC_DATAW2SnU_RD(x, n) & ~(v)))
#define HW_FMC_DATAW2SnU_TOG(x, n, v) (HW_FMC_DATAW2SnU_WR(x, n, HW_FMC_DATAW2SnU_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW2SnU bitfields
 */

/*!
 * @name Register FMC_DATAW2SnU, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW2SnU_data (0U)         /*!< Bit position for FMC_DATAW2SnU_data. */
#define BM_FMC_DATAW2SnU_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW2SnU_data. */
#define BS_FMC_DATAW2SnU_data (32U)        /*!< Bit field size in bits for FMC_DATAW2SnU_data. */

/*! @brief Read current value of the FMC_DATAW2SnU_data field. */
#define BR_FMC_DATAW2SnU_data(x, n) (HW_FMC_DATAW2SnU(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW2SnU_data. */
#define BF_FMC_DATAW2SnU_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW2SnU_data) & BM_FMC_DATAW2SnU_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW2SnU_data(x, n, v) (HW_FMC_DATAW2SnU_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_FMC_DATAW2SnL - Cache Data Storage (lower word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW2SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw2snl
{
    uint32_t U;
    struct _hw_fmc_dataw2snl_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [31:0] of data entry */
    } B;
} hw_fmc_dataw2snl_t;

/*!
 * @name Constants and macros for entire FMC_DATAW2SnL register
 */
/*@{*/
#define HW_FMC_DATAW2SnL_COUNT (4U)

#define HW_FMC_DATAW2SnL_ADDR(x, n) ((x) + 0x244U + (0x8U * (n)))

#define HW_FMC_DATAW2SnL(x, n)   (*(__IO hw_fmc_dataw2snl_t *) HW_FMC_DATAW2SnL_ADDR(x, n))
#define HW_FMC_DATAW2SnL_RD(x, n) (HW_FMC_DATAW2SnL(x, n).U)
#define HW_FMC_DATAW2SnL_WR(x, n, v) (HW_FMC_DATAW2SnL(x, n).U = (v))
#define HW_FMC_DATAW2SnL_SET(x, n, v) (HW_FMC_DATAW2SnL_WR(x, n, HW_FMC_DATAW2SnL_RD(x, n) |  (v)))
#define HW_FMC_DATAW2SnL_CLR(x, n, v) (HW_FMC_DATAW2SnL_WR(x, n, HW_FMC_DATAW2SnL_RD(x, n) & ~(v)))
#define HW_FMC_DATAW2SnL_TOG(x, n, v) (HW_FMC_DATAW2SnL_WR(x, n, HW_FMC_DATAW2SnL_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW2SnL bitfields
 */

/*!
 * @name Register FMC_DATAW2SnL, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW2SnL_data (0U)         /*!< Bit position for FMC_DATAW2SnL_data. */
#define BM_FMC_DATAW2SnL_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW2SnL_data. */
#define BS_FMC_DATAW2SnL_data (32U)        /*!< Bit field size in bits for FMC_DATAW2SnL_data. */

/*! @brief Read current value of the FMC_DATAW2SnL_data field. */
#define BR_FMC_DATAW2SnL_data(x, n) (HW_FMC_DATAW2SnL(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW2SnL_data. */
#define BF_FMC_DATAW2SnL_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW2SnL_data) & BM_FMC_DATAW2SnL_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW2SnL_data(x, n, v) (HW_FMC_DATAW2SnL_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_FMC_DATAW3SnU - Cache Data Storage (upper word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW3SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw3snu
{
    uint32_t U;
    struct _hw_fmc_dataw3snu_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [63:32] of data entry */
    } B;
} hw_fmc_dataw3snu_t;

/*!
 * @name Constants and macros for entire FMC_DATAW3SnU register
 */
/*@{*/
#define HW_FMC_DATAW3SnU_COUNT (4U)

#define HW_FMC_DATAW3SnU_ADDR(x, n) ((x) + 0x260U + (0x8U * (n)))

#define HW_FMC_DATAW3SnU(x, n)   (*(__IO hw_fmc_dataw3snu_t *) HW_FMC_DATAW3SnU_ADDR(x, n))
#define HW_FMC_DATAW3SnU_RD(x, n) (HW_FMC_DATAW3SnU(x, n).U)
#define HW_FMC_DATAW3SnU_WR(x, n, v) (HW_FMC_DATAW3SnU(x, n).U = (v))
#define HW_FMC_DATAW3SnU_SET(x, n, v) (HW_FMC_DATAW3SnU_WR(x, n, HW_FMC_DATAW3SnU_RD(x, n) |  (v)))
#define HW_FMC_DATAW3SnU_CLR(x, n, v) (HW_FMC_DATAW3SnU_WR(x, n, HW_FMC_DATAW3SnU_RD(x, n) & ~(v)))
#define HW_FMC_DATAW3SnU_TOG(x, n, v) (HW_FMC_DATAW3SnU_WR(x, n, HW_FMC_DATAW3SnU_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW3SnU bitfields
 */

/*!
 * @name Register FMC_DATAW3SnU, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW3SnU_data (0U)         /*!< Bit position for FMC_DATAW3SnU_data. */
#define BM_FMC_DATAW3SnU_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW3SnU_data. */
#define BS_FMC_DATAW3SnU_data (32U)        /*!< Bit field size in bits for FMC_DATAW3SnU_data. */

/*! @brief Read current value of the FMC_DATAW3SnU_data field. */
#define BR_FMC_DATAW3SnU_data(x, n) (HW_FMC_DATAW3SnU(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW3SnU_data. */
#define BF_FMC_DATAW3SnU_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW3SnU_data) & BM_FMC_DATAW3SnU_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW3SnU_data(x, n, v) (HW_FMC_DATAW3SnU_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_FMC_DATAW3SnL - Cache Data Storage (lower word)
 ******************************************************************************/

/*!
 * @brief HW_FMC_DATAW3SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw3snl
{
    uint32_t U;
    struct _hw_fmc_dataw3snl_bitfields
    {
        uint32_t data : 32;            /*!< [31:0] Bits [31:0] of data entry */
    } B;
} hw_fmc_dataw3snl_t;

/*!
 * @name Constants and macros for entire FMC_DATAW3SnL register
 */
/*@{*/
#define HW_FMC_DATAW3SnL_COUNT (4U)

#define HW_FMC_DATAW3SnL_ADDR(x, n) ((x) + 0x264U + (0x8U * (n)))

#define HW_FMC_DATAW3SnL(x, n)   (*(__IO hw_fmc_dataw3snl_t *) HW_FMC_DATAW3SnL_ADDR(x, n))
#define HW_FMC_DATAW3SnL_RD(x, n) (HW_FMC_DATAW3SnL(x, n).U)
#define HW_FMC_DATAW3SnL_WR(x, n, v) (HW_FMC_DATAW3SnL(x, n).U = (v))
#define HW_FMC_DATAW3SnL_SET(x, n, v) (HW_FMC_DATAW3SnL_WR(x, n, HW_FMC_DATAW3SnL_RD(x, n) |  (v)))
#define HW_FMC_DATAW3SnL_CLR(x, n, v) (HW_FMC_DATAW3SnL_WR(x, n, HW_FMC_DATAW3SnL_RD(x, n) & ~(v)))
#define HW_FMC_DATAW3SnL_TOG(x, n, v) (HW_FMC_DATAW3SnL_WR(x, n, HW_FMC_DATAW3SnL_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FMC_DATAW3SnL bitfields
 */

/*!
 * @name Register FMC_DATAW3SnL, field data[31:0] (RW)
 */
/*@{*/
#define BP_FMC_DATAW3SnL_data (0U)         /*!< Bit position for FMC_DATAW3SnL_data. */
#define BM_FMC_DATAW3SnL_data (0xFFFFFFFFU) /*!< Bit mask for FMC_DATAW3SnL_data. */
#define BS_FMC_DATAW3SnL_data (32U)        /*!< Bit field size in bits for FMC_DATAW3SnL_data. */

/*! @brief Read current value of the FMC_DATAW3SnL_data field. */
#define BR_FMC_DATAW3SnL_data(x, n) (HW_FMC_DATAW3SnL(x, n).U)

/*! @brief Format value for bitfield FMC_DATAW3SnL_data. */
#define BF_FMC_DATAW3SnL_data(v) ((uint32_t)((uint32_t)(v) << BP_FMC_DATAW3SnL_data) & BM_FMC_DATAW3SnL_data)

/*! @brief Set the data field to a new value. */
#define BW_FMC_DATAW3SnL_data(x, n, v) (HW_FMC_DATAW3SnL_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * hw_fmc_t - module struct
 ******************************************************************************/
/*!
 * @brief All FMC module registers.
 */
#pragma pack(1)
typedef struct _hw_fmc
{
    __IO hw_fmc_pfapr_t PFAPR;             /*!< [0x0] Flash Access Protection Register */
    __IO hw_fmc_pfb0cr_t PFB0CR;           /*!< [0x4] Flash Bank 0 Control Register */
    __IO hw_fmc_pfb1cr_t PFB1CR;           /*!< [0x8] Flash Bank 1 Control Register */
    uint8_t _reserved0[244];
    __IO hw_fmc_tagvdw0sn_t TAGVDW0Sn[4];  /*!< [0x100] Cache Tag Storage */
    __IO hw_fmc_tagvdw1sn_t TAGVDW1Sn[4];  /*!< [0x110] Cache Tag Storage */
    __IO hw_fmc_tagvdw2sn_t TAGVDW2Sn[4];  /*!< [0x120] Cache Tag Storage */
    __IO hw_fmc_tagvdw3sn_t TAGVDW3Sn[4];  /*!< [0x130] Cache Tag Storage */
    uint8_t _reserved1[192];
    struct {
        __IO hw_fmc_dataw0snu_t DATAW0SnU; /*!< [0x200] Cache Data Storage (upper word) */
        __IO hw_fmc_dataw0snl_t DATAW0SnL; /*!< [0x204] Cache Data Storage (lower word) */
    } DATAW0Sn[4];
    struct {
        __IO hw_fmc_dataw1snu_t DATAW1SnU; /*!< [0x220] Cache Data Storage (upper word) */
        __IO hw_fmc_dataw1snl_t DATAW1SnL; /*!< [0x224] Cache Data Storage (lower word) */
    } DATAW1Sn[4];
    struct {
        __IO hw_fmc_dataw2snu_t DATAW2SnU; /*!< [0x240] Cache Data Storage (upper word) */
        __IO hw_fmc_dataw2snl_t DATAW2SnL; /*!< [0x244] Cache Data Storage (lower word) */
    } DATAW2Sn[4];
    struct {
        __IO hw_fmc_dataw3snu_t DATAW3SnU; /*!< [0x260] Cache Data Storage (upper word) */
        __IO hw_fmc_dataw3snl_t DATAW3SnL; /*!< [0x264] Cache Data Storage (lower word) */
    } DATAW3Sn[4];
} hw_fmc_t;
#pragma pack()

/*! @brief Macro to access all FMC registers. */
/*! @param x FMC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_FMC(FMC_BASE)</code>. */
#define HW_FMC(x)      (*(hw_fmc_t *)(x))

#endif /* __HW_FMC_REGISTERS_H__ */
/* EOF */
