#include "mbed.h"
#include "EFM32_SegmentLCD.h"

DigitalOut  led1(LED1); //PE2
DigitalOut  led2(LED2); //PE3

DigitalOut  PhotoSenEXC(PD6);
DigitalIn   PhotoSen(PC6);

silabs::EFM32_SegmentLCD segmentDisplay;

DigitalOut bcEnablePin(PF7);
Serial pc(USBTX, USBRX);    //PE0,PE1

int main() {

    bcEnablePin = 1;        //for PC Communication
    pc.baud(115200);        //only 115200bps by mbed chip
    pc.printf("test\r\n");

    PhotoSenEXC = 1;        //PhotoSensor ON

    segmentDisplay.Write("Hello");
    
    segmentDisplay.EnergyMode(0,1);     //0~4
    segmentDisplay.EnergyMode(1,1);

    segmentDisplay.Battery(5);          //0~5
    segmentDisplay.ARing(0,1);          //0~7
    segmentDisplay.ARing(1,1);
    segmentDisplay.ARing(2,1);
    
    segmentDisplay.Symbol(LCD_SYMBOL_GECKO,1);
    segmentDisplay.Symbol(LCD_SYMBOL_ANT,1);
    segmentDisplay.Symbol(LCD_SYMBOL_PAD0,1);
    segmentDisplay.Symbol(LCD_SYMBOL_PAD1,1);
    segmentDisplay.Symbol(LCD_SYMBOL_EFM32,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_MINUS,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP2,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP3,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP4,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP5,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP6,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_COL3,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_COL5,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_COL10,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DP10,1);
    segmentDisplay.Number(129);
    segmentDisplay.Symbol(LCD_SYMBOL_DEGC,1);
//    segmentDisplay.Symbol(LCD_SYMBOL_DEGF,1);

    while(1) {
        led2 = PhotoSen;

        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
}
