#include "mbed.h"

AnalogIn   sen1(A0);
AnalogIn   sen2(A1);

DigitalOut led1(LED2);
DigitalOut led2(LED1);

DigitalOut port1(D7);
DigitalOut port2(D6);

Serial pc(USBTX,USBRX);

Ticker flipper;

unsigned char f_sen1 = 0;
unsigned char f_sen2 = 0;
void flip() 
{
    if(sen1 > 0.3f)
    {
        f_sen1 = 1;
    }
    else
    {
        f_sen1 = 0;
    }
    if(sen2 > 0.3f)
    {
        f_sen2 = 1;
    }
    else
    {
        f_sen2 = 0;
    }
}

int main(void)
{
    flipper.attach_us(&flip, 10000);//10ms 
    while (1)
    {
        if(f_sen1 == 1)
        {
            led1 = 0;
            port1 = 0;
            wait_ms(500);
        }
        else
        {
            led1 = 1;
            port1 = 1;
        }
        if(f_sen2 == 1)
        {
            led2 = 0;
            port2 = 0;
            wait_ms(500);
        }
        else
        {
            led2 = 1;
            port2 = 1;
        }

        wait_ms(10);
    }
}
