// ==================================================== Dec 21 2013, kayeks ==
// VS1053.h
// ===========================================================================
// Just a simple library for VLSI's mp3/midi codec chip
//   - Minimal and simple implementation (and dirty too)

#ifndef KAYX_VS1053_H_
#define KAYX_VS1053_H_
#pragma O3
//SCI_MODE register bits
#define SM_DIFF         0x0001
#define SM_SETTOZERO    0x0002
#define SM_RESET        0x0004
#define SM_OUTOFWAV     0x0008
#define SM_PDOWN        0x0010
#define SM_TESTS        0x0020
#define SM_STREAM       0x0040
#define SM_PLUSV        0x0080
#define SM_DACT         0x0100
#define SM_SDIORD       0x0200
#define SM_SDISHARE     0x0400
#define SM_SDINEW       0x0800
#define SM_ADPCM        0x1000
#define SM_ADPCM_HP     0x2000

#define SineWave_10k        (0x1D)
#define SineWave_1k         (0xA8)


/** Class VS1053. Drives VLSI's mp3/midi codec chip. */
class VS1053 {
private:
    SPI        spi;
    DigitalOut cs;
    DigitalOut dcs;
    DigitalIn  dreq;
    DigitalOut rst;

public:
    static const uint8_t SCI_MODE        = 0x00;
    static const uint8_t SCI_STATUS      = 0x01;
    static const uint8_t SCI_BASS        = 0x02;
    static const uint8_t SCI_CLOCKF      = 0x03;
    static const uint8_t SCI_DECODE_TIME = 0x04;
    static const uint8_t SCI_AUDATA      = 0x05;
    static const uint8_t SCI_WRAM        = 0x06;
    static const uint8_t SCI_WRAMADDR    = 0x07;
    static const uint8_t SCI_HDAT0       = 0x08;
    static const uint8_t SCI_HDAT1       = 0x09;
    static const uint8_t SCI_AIADDR      = 0x0a;
    static const uint8_t SCI_VOL         = 0x0b;
    static const uint8_t SCI_AICTRL0     = 0x0c;
    static const uint8_t SCI_AICTRL1     = 0x0d;
    static const uint8_t SCI_AICTRL2     = 0x0e;
    static const uint8_t SCI_AICTRL3     = 0x0f;
    
    VS1053(PinName mosiPin, PinName misoPin, PinName sckPin,
           PinName csPin, PinName dcsPin, PinName dreqPin, PinName rstPin,
           uint32_t spiFrequency=7000000);
    ~VS1053();
    void hardwareReset();
    void sendDataByte(uint8_t data);
    size_t sendDataBlock(uint8_t* data, size_t length);
    bool checkDREQ();
    void sci_init();
    void sdi_init();
    bool sendCancel();
    bool stop();
    void sine_test_activate(unsigned char wave);
    void sine_test_deactivate();
    void VolControl(uint16_t vol);
    uint16_t readReg(uint8_t);

private:
    void writeReg(uint8_t, uint16_t);
    uint32_t useSpiFreq;
    void sci_en();
    void sci_dis();
    void sdi_en();
    void sdi_dis();
};

#endif
