#include "TouchPanel.h"

#define pin_YU  (P0_14)
#define pin_XL  (P1_27)
#define pin_YD  (P1_25)
#define pin_XR  (P0_13)

uint16_t readTouchPanelX_Analog()
{
    uint16_t tmp = 0;
    //change to Pinmode for TouchPanelRead
    DigitalOut  TouchPanel_WRtoYU(pin_YU);
    DigitalOut  TouchPanel_D7toYD(pin_YD);
    DigitalIn   TouchPanel_D6toXL(pin_XL);  //require Hi-Z
    AnalogIn    TouchPanel_RStoXR(pin_XR);  //X position read

    TouchPanel_WRtoYU = 1;                  //require VDD
    TouchPanel_D7toYD = 0;                  //require VSS
    wait_us(100);
    tmp = TouchPanel_RStoXR.read_u16();    //read X touch position

    //revert to DigitalOut
    DigitalOut TouchPanel_YUtoWR(pin_YU);
    DigitalOut TouchPanel_YDtoD7(pin_YD);
    DigitalOut TouchPanel_XLtoD6(pin_XL);
    DigitalOut TouchPanel_XRtoRS(pin_XR);

    return tmp;
}

uint16_t readTouchPanelY_Analog()
{
    uint16_t tmp = 0;
    //change to Pinmode for TouchPanelRead
    DigitalOut  TouchPanel_RStoXR(pin_XR);
    DigitalOut  TouchPanel_D6toXL(pin_XL);
    DigitalIn   TouchPanel_D7toYD(pin_YD);  //require Hi-Z
    AnalogIn    TouchPanel_WRtoYU(pin_YU);  //Y position read

    TouchPanel_D6toXL = 1;                  //require VDD
    TouchPanel_RStoXR = 0;                  //require VSS
    wait_us(100);
    tmp = TouchPanel_WRtoYU.read_u16();    //read Y touch position

    //revert to DigitalOut
    DigitalOut TouchPanel_XRtoRS(pin_XR);
    DigitalOut TouchPanel_XLtoD6(pin_XL);
    DigitalOut TouchPanel_YDtoD7(pin_YD);
    DigitalOut TouchPanel_YUtoWR(pin_YU);

    return tmp;
}


/* int32_t getTouchPanelPosX(uint16_t ad_x)                                */
/* argument                                                                 */
/*    uint16_t ad_x:TouchPanel ADC X axis value                             */
/* retuen -1:not touch TouchPanel                                           */
/*        positive integer(0~TOUCHPANEL_X_MAX_SIZE):touch position X axis   */
int32_t getTouchPanelPosX()
{
#define TOUCHPANEL_X_MAX_SIZE   (320)       //touchPanel axis X max size
#define CALIB_TOUCH_X1_POSITION (40)        //touchPanel X position1(0~TOUCHPANEL_X_MAX_SIZE)
#define CALIB_TOUCH_X1_AD_VALUE (14700)     //X1 position touch ADCvalue
#define CALIB_TOUCH_X2_POSITION (280)       //touchPanel X position2(0~TOUCHPANEL_X_MAX_SIZE)
#define CALIB_TOUCH_X2_AD_VALUE (50800)     //X2 position touch ADCvalue

    uint16_t ad_x = readTouchPanelX_Analog();

    //Calculate scale factor for "touch ADC value" to "TouchPanel X Position"
    const uint16_t COEF_CONV_X_POS = abs(CALIB_TOUCH_X1_AD_VALUE - CALIB_TOUCH_X2_AD_VALUE) / 
                                       abs(CALIB_TOUCH_X1_POSITION - CALIB_TOUCH_X2_POSITION);

    //Calculate minimum touch AD value for not touch TouchPanel
    const uint16_t MINIMUM_AD_X_VALUE = CALIB_TOUCH_X1_AD_VALUE - ( (CALIB_TOUCH_X1_POSITION - 0) * COEF_CONV_X_POS);
    int32_t calc_XPos = 0;

    if(ad_x <= MINIMUM_AD_X_VALUE)
    {
        calc_XPos = -1;
    }
    else if(ad_x >= CALIB_TOUCH_X1_AD_VALUE )   //if touch position upper then X1_POSITION
    {
        calc_XPos = CALIB_TOUCH_X1_POSITION + abs(CALIB_TOUCH_X1_AD_VALUE - ad_x)/COEF_CONV_X_POS;
    }
    else                                        //if touch position lower then X1_POSITION
    {
        calc_XPos = CALIB_TOUCH_X1_POSITION - abs(CALIB_TOUCH_X1_AD_VALUE - ad_x)/COEF_CONV_X_POS;
    }

    //If touch position over X_MAX_SIZE,to be treated as not touch TouchPanel
    if(calc_XPos >= TOUCHPANEL_X_MAX_SIZE)
    {
        calc_XPos = -1;
    }
    return calc_XPos;
}

/* int32_t getTouchPanelPosY(uint16_t ad_y)                                */
/* argument                                                                 */
/*    uint16_t ad_y:TouchPanel ADC Y axis value                             */
/* retuen -1:not touch TouchPanel                                           */
/*        positive integer(0~TOUCHPANEL_Y_MAX_SIZE):touch position Y axis   */
int32_t getTouchPanelPosY()
{
#define TOUCHPANEL_Y_MAX_SIZE   (240)       //touchPanel axis Y max size
#define CALIB_TOUCH_Y1_POSITION (40)        //touchPanel Y position1(0~TOUCHPANEL_Y_MAX_SIZE)
#define CALIB_TOUCH_Y1_AD_VALUE (45000)     //Y1 position touch ADCvalue
#define CALIB_TOUCH_Y2_POSITION (200)       //touchPanel Y position2(0~TOUCHPANEL_Y_MAX_SIZE)
#define CALIB_TOUCH_Y2_AD_VALUE (16500)     //Y2 position touch ADCvalue

    uint16_t ad_y = readTouchPanelY_Analog();

    //Calculate scale factor for "touch ADC value" to "TouchPanel Y Position"
    const uint16_t COEF_CONV_Y_POS = abs(CALIB_TOUCH_Y1_AD_VALUE - CALIB_TOUCH_Y2_AD_VALUE) / 
                                       abs(CALIB_TOUCH_Y1_POSITION - CALIB_TOUCH_Y2_POSITION);

    //Calculate minimum touch AD value for not touch TouchPanel
    const uint16_t MINIMUM_AD_Y_VALUE = CALIB_TOUCH_Y2_AD_VALUE - ( (TOUCHPANEL_Y_MAX_SIZE - CALIB_TOUCH_Y2_POSITION) * COEF_CONV_Y_POS);
    
    int32_t calc_YPos = 0;

    if(ad_y <= MINIMUM_AD_Y_VALUE)
    {
        calc_YPos = -1;
    }
    else if(ad_y <= CALIB_TOUCH_Y1_AD_VALUE )
    {
        calc_YPos = CALIB_TOUCH_Y1_POSITION + abs(CALIB_TOUCH_Y1_AD_VALUE - ad_y)/COEF_CONV_Y_POS;
    }
    else
    {
        calc_YPos = CALIB_TOUCH_Y1_POSITION - abs(CALIB_TOUCH_Y1_AD_VALUE - ad_y)/COEF_CONV_Y_POS;
    }
    
    //If touch position over Y_MAX_SIZE,to be treated as not touch TouchPanel
    if(calc_YPos >= TOUCHPANEL_Y_MAX_SIZE)
    {
        calc_YPos = -1;
    }
    return calc_YPos;
}