#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

Serial pc(USBTX, USBRX); // tx, rx
EthernetNetIf eth; 
HTTPClient http;

HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}

int main() {
  pc.baud(921600);

  printf("Start\r\n");

  printf("Setting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\r\n");
  http.basicAuth("username", "supertweet_password");
  HTTPStream stream;
  
  char BigBuf[512 + 1] = {0};
  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
  HTTPResult r = http.get("http://api.supertweet.net/1.1/statuses/home_timeline.json", &stream, request_callback); 
  //HTTPResult r = http.get("http://api.supertweet.net/1.1/statuses/mentions_timeline.json", &stream, request_callback);

  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
      printf("%s",BigBuf); //Display it while loading
      //Note: some servers do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  printf("\n--------------\n");
  if(result == HTTP_OK)
  {
    printf("Read completely\n"); 
  }
  else
  {
    printf("Error %d\n", result);
  }
  
  while(1)
  {
  
  }
  
  return 0;
  
}
