#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include <time.h>
#include <locale.h>

Serial pc(USBTX, USBRX); // tx, rx
EthernetInterface eth;
HTTPClient http;
NTPClient ntp;
char str[512];
char JSTTime[128];

int main() 
{
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      ctTime += 32400;  //Conv UTC to JST
      sprintf(JSTTime,"%s", ctime(&ctTime));
      printf("%s",JSTTime);
    }
    else
    {
      printf("Error\r\n");
    } 
    HTTPMap map;
    HTTPText inText(str, 512);
/******************************************************/
//Input your StewGate Token
/******************************************************/
    const char StewGate_Token[] = "";
    map.put("_t", StewGate_Token);
/****************************************/
// Switch Get Tweet or Post Tweet
/****************************************/
#if 0
    printf("\nTrying to Get Tweet\n");
    int ret = http.post("http://stewgate-u.appspot.com/api/last_mention/", map, &inText);
#else
    char PostTweet[512];
    sprintf(PostTweet,"test in mbed %s",JSTTime);
    map.put("msg", PostTweet);
    printf("\nTrying to Post Tweet\n");
    int ret = http.post("http://stewgate-u.appspot.com/api/post/", map, &inText);
#endif
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }    
    eth.disconnect();  

    while(1) {
    }
}
