#include "mbed.h"
#include "RingBuffer.h"

RawSerial  pc(USBTX, USBRX);
RawSerial  dev(D1, D0);

RingBuffer pc2devBuffer(1024);
RingBuffer dev2pcBuffer(1024);

void dev_recv()
{
    dev2pcBuffer.put(dev.getc());
}

void pc_recv()
{
    pc2devBuffer.put(pc.getc());
}

int main()
{
    char tmp;
    int ret;
    pc.baud(115200);
    dev.baud(115200);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);

    while(1)
    {
        ret = dev2pcBuffer.get(&tmp);
        if( ret == 0 )
        {
            pc.putc(tmp);
        }
        
        ret = pc2devBuffer.get(&tmp);
        if( ret == 0 )
        {
            dev.putc(tmp);
        }
    }
}
