#include "mbed.h"
#include "stm32f3xx_hal_rcc.h"
#include "cmsis_nvic.h"

DigitalOut myled(LED1);
static void MX_TIM6_Init(void);
static void MX_NVIC_Init(void);

void TIM6_DAC1_IRQHandler2(void);

TIM_HandleTypeDef htim6;
void TIM6_DAC1_IRQHandler2(void)
{
    static uint8_t flag = 0;
    myled = flag;
    flag = !flag;
}

static void MX_NVIC_Init(void)
{
    /* TIM6_DAC1_IRQn interrupt configuration */
    HAL_NVIC_SetPriority(TIM6_DAC1_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(TIM6_DAC1_IRQn);
}

/* TIM6 init function */
static void MX_TIM6_Init(void)
{
    __TIM6_CLK_ENABLE();
    htim6.Instance = TIM6;
    htim6.Init.Prescaler = 1;
    htim6.Init.CounterMode = TIM_COUNTERMODE_UP;
    htim6.Init.Period = 256;
    if (HAL_TIM_Base_Init(&htim6) != HAL_OK) {
        while(1) {
        }
    }
    HAL_TIM_Base_Start_IT(&htim6);
}

int main()
{
    MX_TIM6_Init();
    NVIC_SetVector(TIM6_DAC1_IRQn, (uint32_t)&TIM6_DAC1_IRQHandler2);
    MX_NVIC_Init();
    while(1) {
    }
    while(0) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
    }
}
