#include <stdio.h>
#include "mbed.h"
#include "SDFileSystem.h"
#include "VS1053.h"
/*
 VS1002 MP3Player
 2012/03/14
 
 このプログラムは以下のURLのソースコードを元に作成しています
 http://mbed.org/cookbook/VS1002-MP3-Decoder
 
接続方法 
 VS1002      |        mbed
 ---------------------------------------
  RESET----------------P1_25

  D2(BSYNC)------------P1_28
  D3(DREQ)-------------P2_3

  D9(CS)---------------P0_2
  D11(MOSI)------------P0_9
  D12(MISO)------------P0_8
  D13(SCK)-------------P1_29

  GND------------------GND(1)
  3.3V-----------------VU(39)

*/

SDFileSystem sd(/*MOSI*/ P1_22, /*MISO*/ P1_21, /*SCK*/ P1_20, /*CS*/ P1_23, /*Mountpoint*/ "sd");
VS1053       mp3(/*MOSI*/ P0_9, /*MISO*/ P0_8, /*SCK*/ P1_29,
                 /*CS*/ P0_2, /*BSYNC*/ P1_28, /*DREQ*/ P2_3, /*RST*/ P1_25, /*SPI freq.*/ 10000000);

//Serial pc(P1_27,P1_26);

const char *fileNameList[] = {
    "/sd/1.mp3",
    "/sd/2.mp3",
};

#define BLOCK_SIZE (1024)

int main ()
{
//    pc.baud(9600);
    printf("Power ON\r\n");
    /*============================================================
     * MP3 Initialising
     *==========================================================*/
    // Initialize VS1053

/* for sine test mode */
//    mp3.sine_test_activate(SineWave_10k);
//    while(1);
    
    mp3.hardwareReset();
    mp3.sci_init();
    mp3.sdi_init();


    wait(0.1);
    /*============================================================
     * This is the good part
     *==========================================================*/
    printf("MP3 init OK\r\n"); 
          
    static FILE *fp = NULL;
    size_t      sizeRead = 0;
    size_t      totalSizeSent=0;
    size_t      fileSize=0;
    uint8_t     buf[BLOCK_SIZE];

    fp = fopen("/sd/2.mp3", "rb");

    fseek( fp, 0, SEEK_END );
    fileSize = ftell( fp );
    printf("file size:%d\r\n",fileSize);

    rewind(fp);

    if (fp) {
        clearerr(fp);     
        totalSizeSent = 0;
    }
    while(1)
    {
        if(totalSizeSent>=fileSize)
        {   // Close when the track reaches the end
            mp3.stop();
            fclose(fp);
            fp = NULL;
            printf("stop\r\n");
            while(1)
            {
            }
        }
        else
        {
            sizeRead = fread(buf, sizeof(uint8_t), BLOCK_SIZE, fp);
            totalSizeSent += mp3.sendDataBlock(buf, sizeRead);
            //printf("total %d Send %d\r\n",totalSizeSent,sizeRead);
        }
    }
}