#pragma import __use_all_ctype

#include "mbed.h"
#include <string.h>
#include "displayCom.h"
#include "15x16fontsLib.h"

#define StrsBufSize (1024)

DigitalOut PowerLED(LED1);
DigitalOut RunLED(LED2);

SPI spi(p5, NC, p7);        //mosi, miso, sclk
BusOut buffer_CS(p23,p22,p21);

Serial pc(USBTX, USBRX);    // tx, rx

//#define _USE_LocalFileRead
#ifdef _USE_LocalFileRead
LocalFileSystem local("local");
#endif

unsigned int ImageBuf[DISPLAY_XSIZE];//16*6
unsigned int ColerMap[DISPLAY_XSIZE];

unsigned int CountChar(char *str)
{
    unsigned char   f_SJISChar = 0;
    unsigned char   c = 0;
    unsigned int    CountChar = 0;

    c = *str;
    while(c != '\0')
    {
        //2バイト文字の判定
        if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && f_SJISChar != 1 )
        {
            f_SJISChar = 1;
        }
        else
        {
            f_SJISChar = 0;
            CountChar++;
        }
        str++;
        c = *str;
    }
    return CountChar;
}

void SPILineOut(unsigned char setLine)
{
    unsigned int data = 0;
    data|= ImageBuf[setLine];
    spi.write(data);
}

void outBordData()
{
    unsigned char ch = 0,Max_ch=0;
    unsigned int i = 0;
    Max_ch = (DISPLAY_XSIZE-16)/16;
    for(ch=0;ch<=Max_ch;ch++)
    {
        buffer_CS = ch;
        wait_us(10);
        for(i=(ch*16);i<(ch*16+16);i++)
        {
            SPILineOut(i);
        }
        wait_us(10);
    }
}

void bufLeftShift_Loop(void)
{
    signed int i = 0;
   
    for(i=(DISPLAY_XSIZE-1);i>=1;i--)
    {
        ImageBuf[i] = ImageBuf[i-1];
    }
    ImageBuf[0] = ImageBuf[(DISPLAY_XSIZE-1)];

}

void bufLeftShift(void)
{
    signed int i = 0;

    for(i=(DISPLAY_XSIZE-1);i>=1;i--)
    {
        ImageBuf[i] = ImageBuf[i-1];
    }
    ImageBuf[0] = 0;
}

void TestMode(void)
{
    unsigned char i = 0;
    
    for(i=0;i<16;i++)
    {
        ImageBuf[i] = 0xffff;
    }

    outBordData();
    
    while(1)
    {
        wait(0.1);
        bufLeftShift_Loop();
        outBordData();
    }
}
/********************************************************/
//Special Function
/********************************************************/
char PC_RcevStrs[StrsBufSize];
char f_PCInput = 0;
unsigned int c_PC_RcevStrs = 0;
unsigned char func_mode = 0;

void callback() {
	PC_RcevStrs[c_PC_RcevStrs] = pc.getc();

	func_mode = 0;

	if(PC_RcevStrs[c_PC_RcevStrs] == 0x1b)	//Esc key
	{
        memset(PC_RcevStrs,0,sizeof(PC_RcevStrs));
		c_PC_RcevStrs = 0;
		pc.printf("All Strs Clear!\r\n");
	}
	else if(PC_RcevStrs[c_PC_RcevStrs] == '\r')
	{
		pc.printf("RecvStrsEnd\r\n");
		PC_RcevStrs[c_PC_RcevStrs] = '\0';
		f_PCInput = 1;
		c_PC_RcevStrs = 0;
	}
	else if( PC_RcevStrs[c_PC_RcevStrs] == 0x08 )	//BackSpace key
	{
		if(c_PC_RcevStrs >= 1)
		{
			PC_RcevStrs[c_PC_RcevStrs] = '\0';
			PC_RcevStrs[c_PC_RcevStrs-1] = '\0';
			c_PC_RcevStrs--;
		}
	}
	else if(PC_RcevStrs[c_PC_RcevStrs] == 0x10) //DLE ^P
	{
		pc.printf("All LED ON Mode!\r\n");
		func_mode = 1;
		c_PC_RcevStrs = 0;
	}
	else
	{
		if( !(c_PC_RcevStrs >= StrsBufSize) )
		{
			c_PC_RcevStrs++;
		}
		else
		{
			pc.printf("Buf Over Size!!!\r\n");		
		}
	}

	if(c_PC_RcevStrs >= 1 )		//char入力処理結果表示
	{
		if( PC_RcevStrs[c_PC_RcevStrs-1] != '\r' )
		{
			pc.printf("rcevStrs=%s\r\n",PC_RcevStrs);
			pc.printf("rcevCnt=%d\r\n",c_PC_RcevStrs);
		}
	}
}

void TestMode_FullON(void)
{
    memset(ImageBuf,0xffff,sizeof(ImageBuf));
    wait(0.1);
    outBordData();
}

int main()
{
    unsigned int i = 0;
    unsigned int StrsDotSize = 0;
    char strs[StrsBufSize]={0x48,0x65,0x6c,0x6c,0x6f,0x57,0x6f,0x72,0x6c,0x64,0x21,0x20,0x83,0x6a,0x83,0x52,
    				0x83,0x6a,0x83,0x52,0x8b,0x5a,0x8f,0x70,0x95,0x94,0x00};
	PowerLED = 1;

	pc.baud(115200);
	pc.attach(&callback);

    spi.format(16,1);
    spi.frequency(500000);

//************************USE Local File Sys************************************//
#ifdef _USE_LocalFileRead
    memset(strs,' ',sizeof(strs));
    // Read text file for display message, if exist.
    FILE *fp;
    fp = fopen("/local/message.txt", "r"); 
    if (fp != NULL) {
        fgets(strs, sizeof(strs), fp);
        fclose(fp);
#if defined(__MICROLIB) && defined(__ARMCC_VERSION) // with microlib and ARM compiler
        free(fp);
#endif

#endif
//************************USE Local File Sys end********************************//

    memset(ImageBuf,0,sizeof(ImageBuf));

    wait(1);
    RunLED = 1;

    //TestMode();

    while(1)
    {
        memset(ImageBuf,0,sizeof(ImageBuf));

		if(f_PCInput == 1)	//char proccses
		{
			memcpy(strs, PC_RcevStrs, sizeof(strs));	//Set Strs
	        memset(PC_RcevStrs,0,sizeof(PC_RcevStrs));	//Clear PC Rcev Buff
			c_PC_RcevStrs = 0;
			f_PCInput = 0;
		}
		while(func_mode == 1)
		{
			TestMode_FullON();
		}
		StrsDotSize = 8*strlen(strs);

        for(i=0;i<(DISPLAY_XSIZE+StrsDotSize);i++)
        {
            drawStr15x16(strs ,i);
            outBordData();
            wait_ms(20);
            if(f_PCInput == 1)	//break to char proccses
            {
            	f_PCInput = 1;
            	break;
        	}
        }
    }
}
