#include "mbed.h"
#include "displayCom.h"
#include "15x16fontsLib.h"

SPI FontROM(p11, p12, p13); // mosi, miso, sclk
DigitalOut FontROM_CS(p14);

static unsigned char matrixdata[32];

static void read_font(unsigned short code) {
    unsigned char  c1, c2, MSB,LSB;
    uint32_t Address, seq;

    // SJIS to kuten code conversion
    c1 = (code>>8);
    c2 = (code & 0xFF);
    seq = (c1<=159 ? c1-129 : c1-193)*188 + (c2<=126 ? c2-64 : c2-65);
    MSB = seq / 94 + 1;
    LSB = seq % 94 + 1;
    Address = 0;
    
    if(     MSB >=  1 && MSB <= 15 && LSB >= 1 && LSB <= 94)
        Address =( (MSB -  1) * 94 + (LSB - 1))*32;
    else if(MSB >= 16 && MSB <= 47 && LSB >= 1 && LSB <= 94)
        Address =( (MSB - 16) * 94 + (LSB - 1))*32 + 0x0AA40L;
    else if(MSB >= 48 && MSB <= 84 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 48) * 94 + (LSB - 1))*32 + 0x21CDFL;
    else if(MSB == 85 &&                LSB >= 1 && LSB <= 94)
        Address = ((MSB - 85) * 94 + (LSB - 1))*32 + 0x3C4A0L;
    else if(MSB >= 88 && MSB <= 89 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 88) * 94 + (LSB - 1))*32 + 0x3D060L;
    
    // if ASCII code
    int font_width;
    if(code >= 0x20 && code <= 0x7F) {
        Address = (code - 0x20)*16 + 255968;
        font_width = 8;
    }
    else {
        font_width = 16;
    }

    // Deselect the device
    FontROM_CS = 1;

    // Setup the spi for 8 bit data, high steady state clock
    FontROM.format(8,3);
    FontROM.frequency(1000000); 
    
    // Select the device by seting chip select low
    FontROM_CS = 0;
    FontROM.write(0x03);    // Read data byte
    FontROM.write(Address>>16 & 0xff);
    FontROM.write(Address>>8 & 0xff);
    FontROM.write(Address & 0xff);
    
    // Send a dummy byte to receive the contents of the WHOAMI register
    for(int i=0; i<(font_width*2); i++)
    {
        matrixdata[i]=FontROM.write(0x00);
    }

    // Deselect the device
    FontROM_CS = 1;
}

static void draw_kanji_15x16(int pos_x, int font_width)
{
    for(int i=0; i<font_width; i++)
    {
        if( ((signed int)(15-i+pos_x) >= 0) && ((15-i+pos_x) <= (DISPLAY_XSIZE-1)) )
        {
            ImageBuf[15-i+pos_x] =  matrixdata[i];
            ImageBuf[15-i+pos_x] |= matrixdata[i+font_width]<<8;
        }
    }
}

void drawStr15x16(char *str ,unsigned int pos_x)
{
    unsigned char   f_SJISChar = 0;
    unsigned char   c = 0;
    unsigned int    SJISChar = 0;
    unsigned int    CountChar = 0;

    c = *str;
    while(c != '\0')
    {
        //2バイト文字の判定
        if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && f_SJISChar != 1 )
        {
            SJISChar = c;
            f_SJISChar = 1;
        }
        else if(f_SJISChar == 1)
        {
            SJISChar = (SJISChar<<8) | c;
            f_SJISChar = 0;
            read_font(SJISChar);
            draw_kanji_15x16(pos_x-CountChar*8,16);
            CountChar+=2;
        }
        else  //ASCII文字
        {
            SJISChar = c;
            f_SJISChar = 0;
            read_font(SJISChar);
            draw_kanji_15x16(pos_x-CountChar*8, 8);
            CountChar++;
        }
        str++;
        c = *str;
    }
}
