#pragma import __use_all_ctype

#include "mbed.h"
#include <string.h>
#include "displayCom.h"
#include "kfont8.h"
#include "8x8fontsLib.h"
#include "15x16fontsLib.h"

SPI spi(p5, p6, p7);        //mosi, miso, sclk
BusOut buffer_CS(p15,p16,p17,p18,p19,p20);
Serial pc(USBTX, USBRX);    // tx, rx
LocalFileSystem local("local"); 

unsigned int ImageBuf[3][DISPLAY_XSIZE];//16*6
unsigned int ColerMap[3][DISPLAY_XSIZE];

unsigned int CountChar_full_W(char *str )
{
    unsigned char   f_SJISChar = 0;
    unsigned char   c = 0;
    unsigned int    CountChar = 0;

    c = *str;
    while(c != '\0')
    {
        //2バイト文字の判定
        if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && f_SJISChar != 1 )
        {
            f_SJISChar = 1;
        }
        else if(f_SJISChar == 1)
        {
            CountChar++;
            f_SJISChar = 0;
        }
        else
        {
            f_SJISChar = 0;
        }

        str++;
        c = *str;
    }
    return CountChar;
}

unsigned int CountChar_half_W(char *str)
{
    unsigned char   f_SJISChar = 0;
    unsigned char   c = 0;
    unsigned int    CountChar = 0;

    c = *str;
    while(c != '\0')
    {
        //2バイト文字の判定
        if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && f_SJISChar != 1 )
        {
            f_SJISChar = 1;
        }
        else
        {
            if( f_SJISChar == 1)
            {
                f_SJISChar = 0;
            }
            else
            {
                CountChar++;
            }
        }
        str++;
        c = *str;
    }
    return CountChar;
}
void SPILineOut(unsigned char setLine)
{
    unsigned int data[3]={0};
    unsigned int i = 0;
    for(i=0;i<=5;i++)
    {
        data[0] |= ((ImageBuf[2][setLine]>>(15-i))&0x01) << (15-(3*i));
    }
    for(i=0;i<=4;i++)
    {
        data[0] |= ((ImageBuf[1][setLine]>>(15-i))&0x01) << (14-(3*i));
        data[0] |= ((ImageBuf[0][setLine]>>(15-i))&0x01) << (13-(3*i));
    }

    for(i=0;i<=5;i++)
    {
        data[1] |= ((ImageBuf[1][setLine]>>(10-i))&0x01) << (15-(3*i));
    }
    for(i=0;i<=4;i++)
    {
        data[1] |= ((ImageBuf[0][setLine]>>(10-i))&0x01) << (14-(3*i));
        data[1] |= ((ImageBuf[2][setLine]>>(9-i))&0x01) << (13-(3*i));
    }

    for(i=0;i<=5;i++)
    {
        data[2] |= ((ImageBuf[0][setLine]>>(5-i))&0x01) << (15-(3*i));
    }
    for(i=0;i<=4;i++)
    {
        data[2] |= ((ImageBuf[2][setLine]>>(4-i))&0x01) << (14-(3*i));
        data[2] |= ((ImageBuf[1][setLine]>>(4-i))&0x01) << (13-(3*i));
    }
    spi.write(data[0]);
    spi.write(data[1]);
    spi.write(data[2]);
}

void outBordData()
{
    unsigned char ch = 0,Max_ch=0;
    unsigned int i = 0;
    Max_ch = (DISPLAY_XSIZE-16)/16;
    for(ch=0;ch<=Max_ch;ch++)
    {
        wait_us(10);
        buffer_CS = 0x01 << ch;
        for(i=(ch*16);i<(ch*16+16);i++)
        {
            SPILineOut(i);
        }
    }
}

void bufLeftShift_Loop(void)
{
    signed int i = 0;
   
    for(i=(DISPLAY_XSIZE-1);i>=1;i--)
    {
        ImageBuf[0][i] = ImageBuf[0][i-1];
        ImageBuf[1][i] = ImageBuf[1][i-1];
        ImageBuf[2][i] = ImageBuf[2][i-1];
    }
    ImageBuf[0][0] = ImageBuf[0][(DISPLAY_XSIZE-1)];
    ImageBuf[1][0] = ImageBuf[1][(DISPLAY_XSIZE-1)];
    ImageBuf[2][0] = ImageBuf[2][(DISPLAY_XSIZE-1)];

}

void bufLeftShift(void)
{
    signed int i = 0;

    for(i=(DISPLAY_XSIZE-1);i>=1;i--)
    {
        ImageBuf[0][i] = ImageBuf[0][i-1];
        ImageBuf[1][i] = ImageBuf[1][i-1];
        ImageBuf[2][i] = ImageBuf[2][i-1];
    }
    ImageBuf[0][0] = 0;
    ImageBuf[1][0] = 0;
    ImageBuf[2][0] = 0;
}

void TestMode(void)
{
    unsigned char i = 0;
    
    for(i=0;i<16;i++)
    {
        ImageBuf[0][i] = 0xffff;
    }
    for(i=16;i<16+16;i++)
    {
        ImageBuf[1][i] = 0xffff;
    }
    for(i=32;i<32+16;i++)
    {
        ImageBuf[2][i] = 0xffff;
    }

    outBordData();
    
    while(1)
    {
        wait(0.1);
        bufLeftShift_Loop();
        outBordData();
    }
}

void SetRandamColer(void)
{
    unsigned char color = 0;
    unsigned int i=0,j=0;

    memset(ColerMap,0,sizeof(ColerMap));
    for(j=0;j<DISPLAY_XSIZE;j++)
    {
        for(i=0;i<16;i++)
        {
            color = rand()%7;
            if(color == COLOR_G || color == COLOR_C || color == COLOR_Y || color == COLOR_W)
            {
                ColerMap[0][j] |= 1<<i;
            }
            if(color == COLOR_R || color == COLOR_Y || color == COLOR_M || color == COLOR_W)
            {
                ColerMap[1][j] |= 1<<i;
            }
            if(color == COLOR_B || color == COLOR_C || color == COLOR_M || color == COLOR_W)
            {
                ColerMap[2][j] |= 1<<i;
            }
        }
    }
}

void ApplyColerMap(void)
{
    unsigned i = 0;
    for(i=0;i<DISPLAY_XSIZE;i++)
    {
        ImageBuf[0][i] = ImageBuf[0][i]&ColerMap[0][i];
        ImageBuf[1][i] = ImageBuf[1][i]&ColerMap[1][i];
        ImageBuf[2][i] = ImageBuf[2][i]&ColerMap[2][i];
    }
}

int main()
{
    unsigned int i = 0;
    unsigned int s_Strs = 0;

    char strs[100]={};
    memset(strs,' ',sizeof(strs));
    // Read text file for display message, if exist.
    FILE *fp;
    fp = fopen("/local/message.txt", "r"); 
    if (fp != NULL) {
        fgets(strs, 100, fp);
        fclose(fp);
#if defined(__MICROLIB) && defined(__ARMCC_VERSION) // with microlib and ARM compiler
        free(fp);
#endif
    }
    spi.format(16,1);
    spi.frequency(1000000);

    memset(ImageBuf,0,sizeof(ImageBuf));

    i=0;
    wait(0.2);
    //TestMode();
    SetRandamColer();

    while(1)
    {
        memset(ImageBuf,0,sizeof(ImageBuf));
        s_Strs = CountChar_half_W(strs)*8;
        s_Strs += CountChar_full_W(strs)*16;
        for(i=0; i<DISPLAY_XSIZE+(s_Strs)-16; i++)
        {
#if 1
            drawStr15x16(strs ,i, COLOR_W);
            ApplyColerMap();
#else
            drawStr15x16_AutoColer(strs ,i);
#endif
            outBordData();
            wait(0.05);
        }
    }
}
