#include "mbed.h"
#include "displayCom.h"
#include "kfont8.h"
#include "8x8fontsLib.h"
#include "unicode2SJIS.h"




extern unsigned short unicode2SJIS(char c);


int offsety = 0;
bool kstate = false;
unsigned char kbuf;

const unsigned char *findface(unsigned short c){
    const unsigned char *p = NULL;
    int i, sum;
    for(sum = i = 0; i < countof(font8table); i++){
        if(font8table[i].start <= c && c <= font8table[i].end){
            p = &font8[(sum + c - font8table[i].start) << 3];
            break;
        }
        sum += font8table[i].end - font8table[i].start + 1;
    }
    return p;
}

// draw 8x8 font
// charWidth 1~8

void drawkanji(unsigned short c,unsigned char color, signed short posX, unsigned char posY,unsigned char charWidth){
    unsigned char i = 0;
    const unsigned char *p = findface(c);
    if(p == NULL) return;

    if(color == COLOR_G || color == COLOR_C || color == COLOR_Y || color == COLOR_W)
    {
        for(i=0;i<charWidth;i++)
        {
            if( (posX+(7-i)) >= 0)
            {
                ImageBuf[0][ posX+(7-i) ] = p[i]<<posY;
            }
        }
    }
    if(color == COLOR_R || color == COLOR_Y || color == COLOR_M || color == COLOR_W)
    {
        for(i=0;i<charWidth;i++)
        {
            if( (posX+(7-i)) >= 0)
            {
                ImageBuf[1][ posX+(7-i) ] = p[i]<<posY;
            }
        }
    }
    if(color == COLOR_B || color == COLOR_C || color == COLOR_M || color == COLOR_W)
    {
        for(i=0;i<charWidth;i++)
        {
            if( (posX+(7-i)) >= 0)
            {

                ImageBuf[2][ posX+(7-i) ] = p[i]<<posY;
            }
        }
    }
}

void drawc(unsigned char c, unsigned char color, signed short posX, unsigned char posY, unsigned char charWidth){
    if(kstate)
    { // 2nd byte of shift-jis
        kstate = false;
        drawkanji( (kbuf << 8 | c),color,posX,posY,charWidth);
    }
    else if((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)){ // 1st byte of shift-jis
        kstate = true;
        kbuf = c;
    }
    else
    { 
        drawkanji( unicode2SJIS_Table[c],color,posX,posY,charWidth);
    }
}

void drawStr8x8(char *str, unsigned char color, signed short posX, unsigned char posY){
    unsigned char c = 0;
    unsigned char f_2byteChar = 0;
    unsigned char countChar = 0;
    signed short tmp_posX = 0;

    c = *str;
    while( (c != '\0') && (posX>=(countChar*8)) )
    {
        drawc(c,color,(posX-(countChar*8)),posY,8);
        if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && f_2byteChar != 1 )
        { // 1st byte of shift-jis
            f_2byteChar = 1;
        }
        else if(f_2byteChar == 1)
        {
            f_2byteChar = 0;
            countChar++;
        }
        else
        {
            f_2byteChar = 0;
            countChar++;
        }
        str++;
        c = *str;
    }
    if( ((posX%8) != 0) && (c != '\0') )
    {
        tmp_posX = posX%8;
        tmp_posX = tmp_posX-8;
        do{
            drawc(c,color,tmp_posX,posY,8);
            if( ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) && (f_2byteChar != 1)){
                f_2byteChar = 1;
                str++;
                c = *str;
            }
            else if(f_2byteChar == 1)
            {
                f_2byteChar = 0;
                countChar++;
            }
            else
            {
                f_2byteChar = 0;
                countChar++;
            }
        }while(  (f_2byteChar == 1) );
    }
}