#include "mbed.h"

#define DEBOUNCEDELAY 500

// Turn ON/OFF the power of TV
int ARRAY_HIGHLOW[] = { 
 2021, 971, 5512, 971, 1522, 473, 525, 473, 524, 473, 524, 473, 524, 474, 523, 474, 524, 
 474, 523, 474, 525, 473, 524, 473, 524, 474, 523, 474, 524, 473, 525, 472, 524, 474, 
 1521, 474, 523, 474, 524, 474, 524, 473, 524, 474, 523, 474, 523, 474, 523, 475, 523, 
 474, 523, 474, 524, 473, 524, 473, 525, 473, 525, 472, 525, 473, 524, 473, 524, 473, 1522, 
 474, 1521, 472, 525, 474, 1521, 474, 1521, 474, 523, 473, 1522, 473, 1522, 473, 525, 8950, 
 5512, 970, 1523, 473, 524, 474, 523, 473, 526, 472, 525, 472, 525, 473, 525, 472, 525, 473, 
 524, 473, 525, 472, 525, 472, 526, 472, 524, 474, 525, 472, 524, 473, 1523, 472, 525, 472, 
 525, 473, 525, 472, 525, 472, 525, 473, 525, 472, 525, 472, 526, 472, 525, 472, 525, 473, 524,
 472, 526, 473, 524, 472, 526, 472, 525, 472, 525, 473, 1521, 474, 1522, 473, 524, 473, 1522,
 473, 1521, 473, 525, 473, 1522, 473, 1521, 473, 525, 8950, 5512, 971, 1522, 473, 524, 473, 525,
 473, 525, 472, 524, 473, 525, 473, 524, 473, 525, 473, 524, 473, 524, 473, 526, 471, 525, 473,
 525, 472, 526, 471, 526, 472, 1523, 472, 525, 472, 526, 471, 526, 471, 526, 472, 526, 471, 527,
 470, 527, 471, 526, 471, 527, 470, 527, 470, 527, 470, 528, 470, 527, 470, 528, 469, 528, 469,
 529, 469, 1525, 469, 1526, 469, 529, 468, 1527, 467, 1528, 467, 530, 467, 1528, 467, 1528, 467, 531,};

DigitalIn g_digitalinButton(P0_17);
PwmOut g_pwmoutLed(P0_13);

void sendSignal()
{
    g_pwmoutLed.period_us( 26 );   // 38KHz => 1/38000[s] = 26.315 * 10 ^ -6 [s] = 26.315 [us]

    int iCountHighLow = sizeof( ARRAY_HIGHLOW ) / sizeof( ARRAY_HIGHLOW[0] );
    for( int iIndexHighLow = 0; iIndexHighLow < iCountHighLow; iIndexHighLow++ )
    {
        g_pwmoutLed.write( 0.5 * (1 - (iIndexHighLow % 2)) );    // iIndexHighLow : even number -> 0.5, uneven number -> 0
        wait_us( ARRAY_HIGHLOW[iIndexHighLow] );
    }
    g_pwmoutLed.write(0);
}

int main()
{
    int iButtonState_prev = 0;
    
    while(1)
    {
        int iButtonState = g_digitalinButton;
        
        if( 0 == iButtonState_prev && 1 == iButtonState )
        {
            sendSignal();
            wait(1);
        }

        iButtonState_prev = iButtonState;
    }
}
