#include "mbed.h"
#include "IRSendPulseWidth.h"

IRSendPulseWidth::IRSendPulseWidth(PinName output) : g_pwmoutLed(output)
{
    g_pwmoutLed.period_us(26);
    g_pwmoutLed.write(0);
}
    
void IRSendPulseWidth::sendSignal(uint16_t *sendDataArray,uint16_t sendDataN)
{
    int iCountHighLow = sendDataN;
    for( int iIndexHighLow = 0; iIndexHighLow < iCountHighLow; iIndexHighLow++ )
    {
        g_pwmoutLed.write( 0.5 * (1 - (iIndexHighLow % 2)) );    // iIndexHighLow : even number -> 0.5, uneven number -> 0
        wait_us( *(sendDataArray+iIndexHighLow) );
    }
    g_pwmoutLed.write(0);
}
