#include "mbed.h"
#include "IRRcevPulseWidth.h"

IRRcevPulseWidth::IRRcevPulseWidth(PinName InputPin) : _inputPin(InputPin)
{
    fRcevStart = 0;
    cIRRcev = 0;
    cIRRceved = 0;
    IRRcevState_prev = 1;
    filterN = 0;
    _inputPin.mode(PullUp);
}

void IRRcevPulseWidth::init(uint16_t *dataPtr,uint16_t dataLim,uint32_t timeout_us)
{
    IRRcevTimeOut = timeout_us;
    limitUpper_dataN = dataLim;
    p_data = dataPtr;
    _timer.start();
    IRRcevMicroSec_prev = _timer.read_us();
}

void IRRcevPulseWidth::setPulseNumFilter(uint16_t n)
{
    filterN = n;
}

uint16_t IRRcevPulseWidth::getData_N(void)
{
    return cIRRceved;
}
    
int8_t IRRcevPulseWidth::status(void)
{
    int8_t ret=0;
    IRRcevMicroSec = _timer.read_us();
    IRRcevMicroSec_diff = IRRcevMicroSec - IRRcevMicroSec_prev;

    IRRcevState = _inputPin;
    if( IRRcevState != IRRcevState_prev )
    {
        if(fRcevStart == 0)
        {
            fRcevStart = 1;
        }
        else
        {
            *(p_data+cIRRcev) = IRRcevMicroSec_diff;
            cIRRcev++;
            if(cIRRcev >= limitUpper_dataN)
            {
                cIRRcev = 0;
                ret = -1;
            }
        }
        IRRcevState_prev = IRRcevState;
        IRRcevMicroSec_prev = IRRcevMicroSec;
    }
    else if( (IRRcevMicroSec_diff >= IRRcevTimeOut) && (cIRRcev != 0) )
    {
#if IR_RCEV_DEBUGOUT_ENABLE
        DBG("Rceved\r\n");
        DBG("RcevCnt:%d\r\n",cIRRcev);
        for(i=0;i<cIRRcev;i++)
        {
            DBG("%d,",*(p_data+i));
        }
        DBG("\r\n");
#endif
        if(cIRRcev >= filterN)
        {
            cIRRceved = cIRRcev;
            cIRRcev = 0;
            fRcevStart = 0;
            ret = 1;
        }
        else
        {
            cIRRcev = 0;
            fRcevStart = 0;
            ret = 0;
        }
    }
    return ret;
}
