#ifndef __IRRCEV_PULSEWIDTH_H__
#define __IRRCEV_PULSEWIDTH_H__

#include "mbed.h"

#define IR_RCEV_DEBUGOUT_ENABLE     (0)

#if IR_RCEV_DEBUGOUT_ENABLE
#define DBG(...) printf("" __VA_ARGS__)
#else
#define DBG(...)
#endif

class IRRcevPulseWidth {
public:
    IRRcevPulseWidth(PinName InputPin);

    void init(uint16_t *dataPtr,uint16_t dataLim,uint32_t timeout_us);
    void setPulseNumFilter(uint16_t n);
    uint16_t getData_N(void);
    int8_t status(void);

private:
    Timer       _timer;
    DigitalIn   _inputPin;
    uint32_t IRRcevMicroSec_prev;
    uint32_t IRRcevMicroSec,IRRcevMicroSec_diff;
    uint8_t  IRRcevState,IRRcevState_prev;
    uint32_t IRRcevTimeOut;
    uint16_t cIRRcev,cIRRceved;
    uint8_t  fRcevStart;
    uint16_t *p_data;
    uint16_t limitUpper_dataN;
    uint16_t filterN;
    uint16_t i;
};

#endif