#include "mbed.h"
#include "IRRcevPulseWidth.h"
#include "IRSendPulseWidth.h"

#define IR_RCEV_MAX_IR_RECEV_NUM    (300)
#define IR_RCEV_TIMEOUT_US          (100000)

DigitalIn sw(D10,PullUp);
IRRcevPulseWidth IRrcev(D12);
IRSendPulseWidth IRsend(D11);
Serial g_serial(USBTX, USBRX);

int main()
{
    uint16_t IR_RcevData[IR_RCEV_MAX_IR_RECEV_NUM];
    uint16_t i;
    int8_t ret;
    
    IRrcev.init(IR_RcevData,IR_RCEV_MAX_IR_RECEV_NUM,IR_RCEV_TIMEOUT_US);
    
    while(1)
    {
        ret = IRrcev.status();
        if(ret == 1)
        {
            g_serial.printf("\r\nproc succes:%d\r\nDUMP\r\n",IRrcev.getData_N());
            for(i=0;i<IRrcev.getData_N();i++)
            {
                g_serial.printf("%d,",IR_RcevData[i]);
            }
        }
        else if(ret == -1)
        {
            g_serial.printf("\r\nCount Over!\r\n");
        }
        //DD11 Low to IRsend
        if(sw == 0)
        {
            g_serial.printf("send\r\n");
            IRsend.sendSignal(IR_RcevData,IRrcev.getData_N());
            wait(2);
        }
    }
}
