#include "mbed.h"
#include "wavChunks.h"
#include "wavPlayer.h"
#include <stdio.h>
#include "SDFileSystem.h"
#include "TIM6Driver.h"

wavPlayerOnDAC::wavPlayerOnDAC(PinName pinDAC) : 
    DACout(pinDAC) 
{
}

void wavPlayerOnDAC::setFile(FIL* tgtFile)
{
    uint16_t i;
    uint32_t    wavReadByte;
    uint32_t        ReadID;
    wavfil = *tgtFile;

    f_read(&wavfil, &wavRIFFHedder, RIFFHedderSize, &wavReadByte);
    printf("hedder:%x\r\n", wavRIFFHedder.riff);
    printf("size:%x\r\n", wavRIFFHedder.size);
    printf("type:%x\r\n", wavRIFFHedder.type);
    
    printf("readID\r\n");
    f_read(&wavfil, &ReadID, sizeof(ReadID), &wavReadByte);
    printf("ID:%x\r\n",ReadID);

    if (ReadID == 0x74786562)   //bext
    {
        printf("\r\n*bextChunk\r\n");
        f_read(&wavfil, &wavBextChunk, BextChunkSize, &wavReadByte);
        printf("size:%x\r\n", wavBextChunk.ckSize);
        f_lseek(&wavfil, f_tell(&wavfil) + wavBextChunk.ckSize);
        f_read(&wavfil, &ReadID, sizeof(ReadID), &wavReadByte);
    }
    if (ReadID == 0x20746D66)
    {
        f_read(&wavfil, &wavFormatChunk, FormatChunkSize, &wavReadByte);
        printf("\r\n*fmtChunk\r\n");
        printf("size:%d\r\n", wavFormatChunk.size);
        printf("format:%d\r\n", wavFormatChunk.format);
        printf("channels:%d\r\n", wavFormatChunk.channels);
        printf("samplerate:%d\r\n", wavFormatChunk.samplerate);
        TIM6ClockSet(TIM6CLK/wavFormatChunk.samplerate);
        printf("byteParSec:%d\r\n", wavFormatChunk.bytepersec);
        printf("blockalign:%d\r\n", wavFormatChunk.blockalign);
        printf("bitswidth:%d\r\n", wavFormatChunk.bitswidth);
        setParameters(wavFormatChunk.bitswidth,wavFormatChunk.channels);
    }

    seaechChunk(&wavfil, "data");
    f_read(&wavfil, &wavDataChunk, DataChunkSize, &wavReadByte);
    printf("\r\n*dataChunk\r\n");
    printf("id:%x\r\n", wavDataChunk.id);
    printf("size:%x\r\n", wavDataChunk.size);
    
    f_read(&wavfil,&wavReadData.raw,WAV_READ_SIZE,&wavReadByte);
    storeWavDatatoBuff(0);
    
    f_read(&wavfil,&wavReadData.raw,WAV_READ_SIZE,&wavReadByte);
    storeWavDatatoBuff(1);
    fWavPlaying = 1;
    dac_c = 0;
    dac_rp=0;
}

//return 0:playing 1:stop
uint8_t wavPlayerOnDAC::readProc(void)
{
    uint16_t i,j;
    uint32_t    wavReadByte;

    if(f_eof(&wavfil) != 0)
    {
        fWavPlaying = 0;
    }

    if(fWavPlaying == 0)
    {
        dac_on = 0;
        return 1;
    }
    dac_on = 1;
    for(j=0;j<2;j++)
    {
        if(dac_flag[j] == 0)
        {
            f_read(&wavfil,&wavReadData.raw,WAV_READ_SIZE,&wavReadByte);
            storeWavDatatoBuff(j);
        }
    }
    return 0;
}

void wavPlayerOnDAC::rewind(void)
{
    f_lseek(&wavfil,0);
    fWavPlaying = 1;
}
void wavPlayerOnDAC::stop(void)
{
    fWavPlaying = 0;
}

void wavPlayerOnDAC::DACOutProc(void)
{
    if(dac_on == 1) {
        if(dac_flag[dac_c] == 1)
        {
            DACout.write_u16(DACData[dac_c][dac_rp]);
            if( dac_rp == dacBuffIndex_n-1)
            {
                dac_flag[dac_c] = 0;
                dac_rp = 0;
                dac_c = (dac_c+1)%2;
            }
            else
            {
                dac_rp++;
            }
        }
    }
}

void wavPlayerOnDAC::rampUp(void)
{
    uint16_t i;
    for(i=0;i<32768;i+=64)
    {
        DACout.write_u16(i);
        wait_us(1);
    }
}
void wavPlayerOnDAC::rampDown(void)
{
    uint16_t i;
    for(i=0;i<32768;i+=64)
    {
        DACout.write_u16(32768-i);
        wait_us(1);
    }
}

uint8_t wavPlayerOnDAC::seaechChunk(FIL *fp,char chunk[5])
{
    uint8_t readByteData;
    uint8_t data[4];
    uint8_t ret=0;
    uint32_t    wavReadByte;


    while ( (f_error(fp) == 0) && (f_eof(fp) == 0) )
    {
        f_read(fp,&readByteData,sizeof(readByteData),&wavReadByte);
        data[0] = readByteData;
        if (data[3] == chunk[0] && data[2] == chunk[1] && data[1] == chunk[2] && data[0] == chunk[3])
        {
            printf("found Chunk\r\n");
            ret = 1;
            break;
        }
        else
        {
            data[3] = data[2];
            data[2] = data[1];
            data[1] = data[0];
        }
    }
    return ret;
}

void wavPlayerOnDAC::setParameters(uint16_t bitsWidth,uint8_t ch)
{
    wavBitsWidth = bitsWidth;
    wavChannels = ch;
    if(wavBitsWidth == 8)
    {
        if(wavChannels == 1)
        {
            dacBuffIndex_n = WAV_READ_SIZE;
        }
        else
        {
            dacBuffIndex_n = WAV_READ_SIZE/2;
        }
    }
    else if(wavBitsWidth == 16)
    {
        if(wavChannels == 1)
        {
            dacBuffIndex_n = WAV_READ_SIZE/2;
        }
        else
        {
            dacBuffIndex_n = WAV_READ_SIZE/4;
        }
    }
}

void wavPlayerOnDAC::storeWavDatatoBuff(uint8_t selectBufNo)
{
    uint16_t i;
    for(i=0;i<dacBuffIndex_n;i++)
    {
        if(wavBitsWidth == 8)
        {
            if(wavChannels == 1)
            {
                DACData[selectBufNo][i] = wavReadData.mono8bit[i]<<8;
            }
            else
            {
                DACData[selectBufNo][i] = wavReadData.stereo8bit[i].L<<8;
            }
        }
        else
        {
            if(wavChannels == 1)
            {
                DACData[selectBufNo][i] = (wavReadData.mono16bit[i])+32768;
            }
            else
            {
                DACData[selectBufNo][i] = (wavReadData.stereo16bit[i].L)+32768;
            }
        }
    }
    dac_flag[selectBufNo] = 1;
}