#include <stdio.h>
#include "SDFileSystem.h"
#include "wavChunks.h"

#define WAV_READ_SIZE (512)

class wavPlayerOnDAC {
public:
    wavPlayerOnDAC(PinName pinDAC);
    void setFile(FIL* tgtFile);
    uint8_t readProc(void);
    void rewind(void);
    void stop(void);
    void DACOutProc(void);
    void setParameters(uint16_t bitsWidth,uint8_t ch);
    void rampUp(void);
    void rampDown(void);

private:
    struct st_streo16bit {
        uint16_t L;
        uint16_t R;
    };
    struct st_streo8bit {
        uint8_t L;
        uint8_t R;
    };

    union {
        uint8_t         raw[WAV_READ_SIZE];
        st_streo16bit   stereo16bit[WAV_READ_SIZE/4];
        uint16_t        mono16bit[WAV_READ_SIZE/2];
        st_streo8bit    stereo8bit[WAV_READ_SIZE/2];
        uint8_t         mono8bit[WAV_READ_SIZE];
    } wavReadData;

    uint16_t    DACData[2][WAV_READ_SIZE];
    FIL         wavfil;
    uint8_t     dac_c;
    uint16_t    dac_rp;
    bool        dac_flag[2];
    uint16_t    dacEndReadPos;
    uint16_t    dacBuffIndex_n;
    uint8_t     fWavPlaying;
    bool        dac_on;
    uint16_t    wavBitsWidth;
    uint8_t     wavChannels;
    
    RIFFHedder_s    wavRIFFHedder;
    BextChunk_s     wavBextChunk;
    FormatChunk_s   wavFormatChunk;
    DataChunk_s     wavDataChunk;
    
    AnalogOut       DACout;
    
    uint8_t seaechChunk(FIL *fp,char chunk[5]);
    void storeWavDatatoBuff(uint8_t selectBufNo);
};
