#include "mbed.h"
#include <stdio.h>
#include "SDFileSystem.h"
#include "wavPlayer.h"
#include "TIM6Driver.h"

void TIM6_IRQHandler(void);
Ticker flipper;
FATFS FatFs;
wavPlayerOnDAC wavPlayer(PA_4);

SDFileSystem sd(PB_5, PB_4, PB_3, PA_11, "sd"); // the pinout on the mbed Cool Components workshop board
DigitalIn button(PF_1,PullDown);
BusIn DipSW(PA_10,PA_9,PA_12,PB_0);

void TIM6_IRQHandler() {
    TIM6ClearInt();
    wavPlayer.DACOutProc();
}

int main(void)
{
    FRESULT wavFileResult;
    FIL     fil;
    char    fileName[10]="0.wav";
    uint8_t oldDipSW=0;
    uint8_t oldButton=0;
    
    MX_TIM6_Init();
    NVIC_SetVector(TIM6_DAC1_IRQn, (uint32_t)&TIM6_IRQHandler);
    MX_NVIC_Init();
    
    DipSW.mode(PullDown);
    f_mount(&FatFs,"",0);
    printf("power ON \r\n");
    wavFileResult = f_open(&fil, "0.wav",FA_READ);
    
    while(1) 
    {
        while(button.read() == 0)
        {
        }
        if(oldDipSW != DipSW.read())
        {
            f_close(&fil);
            fileName[0] = DipSW.read()+0x30;
            printf("name:%s\r\n",fileName);
            wavFileResult = f_open(&fil, fileName, FA_READ);
        }
        oldDipSW = DipSW.read();
        printf("error:%d\r\n",(int)wavFileResult);
        wavPlayer.setFile(&fil);
        printf("start\r\n");
        wavPlayer.rampUp();
        oldButton = button.read();
        while(wavPlayer.readProc() == 0)
        {
            if(button.read() == 1 && oldButton == 0)
            {
                break;
            }
            oldButton = button.read();
        }
        printf("END\r\n");
        wavPlayer.rewind();
        wavPlayer.rampDown();
        while(button.read() == 1 && oldButton == 1)
        {
        }

    }
}