#include "TIM6Driver.h"

TIM_HandleTypeDef htim6;

void MX_NVIC_Init(void)
{
    /* TIM6_DAC1_IRQn interrupt configuration */
    HAL_NVIC_SetPriority(TIM6_DAC1_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(TIM6_DAC1_IRQn);
}

/* TIM6 init function */
void MX_TIM6_Init(void)
{
    __TIM6_CLK_ENABLE();
    htim6.Instance = TIM6;
    htim6.Init.Prescaler = 1;
    htim6.Init.CounterMode = TIM_COUNTERMODE_UP;
    htim6.Init.Period = 2000;
    HAL_TIM_Base_Init(&htim6);
    HAL_TIM_Base_Start_IT(&htim6);
}

void TIM6ClockSet(uint16_t setPeriod)
{
    htim6.Instance = TIM6;
    htim6.Init.Prescaler = 1;
    htim6.Init.CounterMode = TIM_COUNTERMODE_UP;
    htim6.Init.Period = setPeriod;
    HAL_TIM_Base_Init(&htim6);
}

void TIM6ClearInt(void)
{
    __HAL_TIM_CLEAR_IT(&htim6 , TIM_FLAG_UPDATE);
}