#include "mbed.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10); //lcd = (MOSI, SCK, RESET, A0, nCS)
InterruptIn sw2(SW2);   //start or stop  start = green led on
InterruptIn sw3(SW3);   //reset
PwmOut Green(D9);
PwmOut Red(D5);
InterruptIn up(A2);
InterruptIn down(A3);
InterruptIn left(A4);
InterruptIn rite(A5);
InterruptIn center(D4);

Timer timer;
int offset = 0;
int start = 0;

void ISR_sw2()
{
    if(start == 0){
    timer.start();
    Green = 0;
    start = 1;
    }
    else{
        timer.stop();
        Green = 1;
        start = 0;
    }
}

void ISR_sw3()
{
        timer.reset();
        offset = 0;
        start = 1;
}

void ISR_up()
{
    if(up)
        offset += 60*1000;
}

void ISR_down()
{
        offset -= 60*1000;
}

void ISR_left()
{
        offset -= 60*60*1000;
}

void ISR_rite()
{
        offset += 60*60*1000;
}

void ISR_center()
{
        offset -= (timer.read_ms()+ offset ) % (60 * 1000); 
}

int main()
{
    long time;
    int hour=0, minute=0, second=0, mili=0;
    Green = Red = 1;
    
    sw2.fall(&ISR_sw2);
    sw3.fall(&ISR_sw3);
    up.rise(&ISR_up);
    down.rise(&ISR_down);
    rite.rise(&ISR_rite);
    left.rise(&ISR_left);
    center.rise(&ISR_center);
    
    lcd.cls();
    lcd.locate(0,6);
    lcd.printf("Digital Clock!");
    while(true){
        time = timer.read_ms();
        if(time + offset < 0)
            offset = -time;
        time = time + offset;
        
        mili = time % 100;
        second = (time / 1000) % 60;
        minute = ((time / 1000) / 60) % 60;
        hour = ((time / 1000) / 3600) % 24;
        lcd.locate(0,16);
        lcd.printf("Current Time: %02d:%02d:%02d:%02d", hour, minute, second, mili);
        thread_sleep_for(100);
    }
}