#include "mbed.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10); //lcd = (MOSI, SCK, RESET, A0, nCS)
PwmOut Red(D5);
PwmOut Green(D9);
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

int count_sw2 = 0;
int count_sw3 = 0;

void ISR_sw2(){
    Red = 0;
    Green = 1;
    count_sw2++;
    }
    
void ISR_sw3(){
    Red = 1;
    Green = 0;
    count_sw3++;
    }

int main()
{
    int loop = 0;
    Red = Green = 1;
    
    sw2.rise(&ISR_sw2);
    sw3.fall(&ISR_sw3);
    
    lcd.cls();
    while(true){
        lcd.locate(0,6);
        lcd.printf("Button ISRs!");
        lcd.locate(0,16);
        lcd.printf("Loop =%i, SW2=%i, SW3=%i", loop, count_sw2, count_sw3);
        ++loop;
        thread_sleep_for(100);
    }
}