#include "mbed.h"
#include "C12832.h"
#include "pitches.h"

C12832 lcd(D11, D13, D12, D7, D10); //lcd = (MOSI, SCK, RESET, A0, nCS)
PwmOut buzzer(PTA1);   //buzzer = PTA1
int length = 56;

float frequency[] = {NOTE_E6, NOTE_DS6, NOTE_E6, NOTE_DS6, NOTE_E6, NOTE_B5, NOTE_D6, NOTE_C6, NOTE_A5,
                        NOTE_C5, NOTE_E5, NOTE_A5, NOTE_B5,
                        NOTE_E5, NOTE_GS5, NOTE_B5, NOTE_C6,
                        NOTE_E6, NOTE_DS6, NOTE_E6, NOTE_DS6, NOTE_E6, NOTE_B5, NOTE_D6,NOTE_C6, NOTE_A5,
                        NOTE_C5, NOTE_E5, NOTE_A5, NOTE_B5,
                        NOTE_E5, NOTE_GS5, NOTE_B5, NOTE_C6,
                        NOTE_B5, NOTE_C6, NOTE_D6, NOTE_E6,
                        NOTE_G5, NOTE_F6, NOTE_E6, NOTE_D6,
                        NOTE_F5, NOTE_E6, NOTE_D6, NOTE_C6,
                        NOTE_E5, NOTE_D6, NOTE_C6, NOTE_B5,
                        NOTE_E5, NOTE_E6};
float beat[] = {12,12,12,12,12,12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,12,12,12,12,12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,12,12,9,
                12,9};


int main()
{
    lcd.cls();
    lcd.locate(0,6);
    lcd.printf("Listen to speaker!");
    lcd.locate(0,16);
    lcd.printf("For Elise~~~");
    while(true) {
        for(int i = 0; i <= length; i++) {
            if(frequency[i] == 0)
                buzzer = 0.0;
            else {
                buzzer.period(1.0 / frequency[i]);  //period = (1.0 / frequency)
                buzzer = 0.5;       //duty cycle = 50%
            }
            thread_sleep_for(3500.0 / beat[i]); //duration = (C / beat)ms
        }
    }
}