#include "mbed.h"

SPISlave spi_slave(PTD2, PTD3, PTD1, PTD0);  //spi_slave = (MOSI, MISO, SCLK, SS)
DigitalOut led(D0);

int main()
{
    unsigned char r;
    spi_slave.format(8,3);        //8bit data, mode 3
    spi_slave.frequency(1000000);  //frequency 1MHz
    led = 0;
    
    while(true) {
        if(spi_slave.receive()) {       //if spi data is ready
            r = spi_slave.read();         //r = received data
            spi_slave.reply(r);             //and send r
            if(r == '1'){                   //if r == 1 turn on Led for 200ms and off
                led = 1;
                thread_sleep_for(200);
                led = 0;
            }
        }
    }
}