#include "mbed.h"

I2CSlave i2c_slave(I2C_SDA, I2C_SCL);  //i2c_slave = (I2C_SDA, I2C_SCL)
DigitalOut led(D0);

const int addr = 0xa0;      //slave addr (even no.)

int main()
{
    int i, r;
    led = 0;
    i2c_slave.address(addr);
    while(true) {
        i = i2c_slave.receive();
        switch(i) {
            case I2CSlave::WriteAddressed:  //WRITE means slave read
                i2c_slave.read();
                r = i2c_slave.read();
                if(r == '1') {
                    led = 1;
                    thread_sleep_for(200);
                    led = 0;
                }
                break;
            default:
                break;
        }
    }
}