#include "mbed.h"
#include "mbed_rpc.h"

// These are examples of some variable types that can be modified through RPC.
int wheelsOn;
char lcdBannerMessage;
float speed;

RPCVariable<int> rpcLights(&wheelsOn, "wheels");
RPCVariable<char> rpcBanner(&lcdBannerMessage, "banner");
RPCVariable<float> rpcSpeed(&speed, "speed");

Serial pc(USBTX, USBRX);

int main() {
    //The mbed RPC classes are now wrapped to create an RPC enabled version - see RpcClasses.h so don't add to base class
    
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}