#include "mbed.h"
#include "mbed_rpc.h"

/**
 *  This example program has been updated to use the RPC implementation in the new mbed libraries.
 *  This example demonstrates using RPC over serial
 */

Serial pc(USBTX, USBRX);
void moveTo(Arguments *in, Reply *out);
RPCFunction rpcMove(&moveTo, "moveTo");
double xLoc, yLoc;

int main() {
    //The mbed RPC classes are now wrapped to create an RPC enabled version - see RpcClasses.h so don't add to base class
    
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}

// Make sure the method takes in Arguments and Reply objects.
void moveTo (Arguments *in, Reply *out)   {
    bool success = true;
    
    // In this scenario, when using RPC delimit the two arguments with a space.
    xLoc = in->getArg<double>();
    yLoc = in->getArg<double>();
 
    // Have code here to move robot to location (xLoc, yLoc) and update success.

    char buffer[200];
    sprintf(buffer, "Successfully moved to location (%f, %f)", xLoc, yLoc);
    if (success) {
        out->putData(buffer);
    } else {
        out->putData("Failed to move to location.");
    }
}
