#ifndef _MY_OLED_H_
#define _MY_OLED_H_

#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "odom.h"
#include "type.h"

class My_Oled : public Odom_Abstract, Adafruit_SSD1306_I2c
{
    private:
        bool display_flag_;
            
    public:
        My_Oled(Odom *odom, I2C &i2c) : Odom_Abstract(odom), Adafruit_SSD1306_I2c(i2c, D10){
            clearDisplay();
            display_flag_ = true;
        }
        
    private:
        //Overlap function
        virtual void loop(){
            static uint32_t counter = 0;
            if(display_flag_ == true && get_enable_oled() == false){
                setTextCursor(0,0);
                clearDisplay();
                display(); 
                display_flag_ = false;
            }
            
            if(get_enable_oled() && (++counter % 20) == 0){
                display_flag_ = true;
                
                setTextCursor(0,0);
                printf("Court color -> %s\n\n", (get_court_color() ? "BLUE" : "RED")); 
                printf("odom  x -> %8.4f\n", get_pose().x());
                printf("      y -> %8.4f\n", get_pose().y());
                printf("      a -> %8.4f\n", get_pose().z());
                printf("drift x -> %8.4f\n", get_drift().x());
                printf("      y -> %8.4f\n", get_drift().y());
                printf("      a -> %8.4f\n", get_drift().z());
                display();  
            }
        }

};
#endif