#ifndef _TYPE_H_
#define _TYPE_H_

#include <ros.h> 
#include <geometry_msgs/Point.h>

class Vec3f{
    private:
        float x_;
        float y_;
        float z_;
        geometry_msgs::Point data_;    
    
    public:
        //Constructor
        Vec3f(float x = 0.0f, float y = 0.0f, float z = 0.0f) : x_(x), y_(y), z_(z){
            //Create point msgs
            data_.x = x;
            data_.y = y;
            data_.z = z;
        }

        //Setter
        void x(float x){
            data_.x = x_ = x;   
        }
        void y(float y){
            data_.y = y_ = y;   
        }
        void z(float z){
            data_.z = z_ = z; 
        }
        void angle(float angle){
            z(angle); 
        }
        
        //Getter
        float x(){
            return x_;
        }
        float y(){
            return y_;
        }
        float z(){
            return z_;
        }
        float angle(){
            return z_;    
        }
        
        geometry_msgs::Point get_point_msgs(){
            return data_;
        }
        
        Vec3f operator + (Vec3f add){
            return Vec3f(x_ + add.x(), y_ + add.y(), z_ + add.z());
        }
};

class Vec4f : public Vec3f
{
    private:
        float w_;
        
    public:
        Vec4f(float x = 0.0f, float y = 0.0f, float z = 0.0f, float w = 0.0f) : Vec3f(x, y, z), w_(w){

        } 
        
        //Setter
        void w(float w){
            w_ = w;   
        }
  
        //Getter
        float w(){
            return w_;
        }
};

#endif