#ifndef _MY_ROS_H_
#define _MY_ROS_H_

#include "type.h"
#include "odom.h"

#include <mbed.h>
#include <ros.h>
#include <ros/time.h>
#include <std_msgs/Bool.h>
#include <geometry_msgs/Point.h>
#include <geometry_msgs/PointStamped.h>
#include <std_msgs/Empty.h>

void ack_from_pc_cb(const std_msgs::Empty&);
void drift_sub_cb(const geometry_msgs::Point& drift);

class My_Ros : public Odom_Abstract
{
    public:
    
    private:
        ros::NodeHandle nh_;
        
    public:
        //Constructor
        My_Ros(Odom *odom) : Odom_Abstract(odom){
//            set_instance(odom);
            set_court_color(COURT_RED);
            
            //ROS node initialize
            nh_.getHardware()->setBaud(115200);
            nh_.initNode();
            
            initialize();
        }
                
        //Setter
        template<typename SubscriberT>
        void set_subscliber(SubscriberT& s){
            nh_.subscribe(s);
        }
        
        //amcl parameter の初期化
        void enable_initialize_amcl();
        
    private:
        //Initialise
        void initialize();
        
        //Publisher
        void court_color_publisher();
        void initial_pose_publisher();
        void pose_publisher();
        
        //Overlap function
        virtual void loop();
};

#endif