#include "mbed.h"
#include "LcdScreen.h"

static void setLeds(int data);
#include "WifiTerminalMode.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

static void setLeds(int data) {
    myled1 = (data & 8) >> 3;
    myled2 = (data & 4) >> 2;
    myled3 = (data & 2) >> 1;
    myled4 = (data & 1);
}

int main() {
    int i = 0;
    unsigned char *p;
    LcdScreen *ls = new LcdScreen();
    WifiTerminalMode *terminal = new WifiTerminalMode();

    // 1st time set up parameters
    ls->print("setting parameters\r\n");
    terminal->reset();
    terminal->serialInit();
    terminal->portSetup();
    setLeds(1);
    // 2nd time do connect
    ls->print("connecting\r\n");
    terminal->reset();
    setLeds(2);
    terminal->serialInit();
    setLeds(3);
    p = terminal->getAddr();
    ls->print(p);
    ls->print((const unsigned char *)"\r\n");
    setLeds(8);
    while (true) {
        setLeds(8 | i);
        i ^= 1;
        p = terminal->readLine();
        ls->print(p);
    }
}
