#include "TextLCD.h"

#define SCREEN_WIDTH    16
#define SCREEN_HEIGHT   2
#define CR  13
#define LF  10

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

class LcdScreen {
protected:
    unsigned char cram[SCREEN_HEIGHT][SCREEN_WIDTH];
    unsigned char lastWritten[SCREEN_HEIGHT][SCREEN_WIDTH];
    int cursorX;
    int cursorY;
public:
    LcdScreen()
    {
        cursorX = 0;
        cursorY = 0;
        
        int x, y;
        for ( y = 0; y < SCREEN_HEIGHT; y++ ) {
            for ( x = 0; x < SCREEN_WIDTH; x++ ) {
                cram[y][x] = ' ';
                lastWritten[y][x] = ' ';
            }
        }
        
        lcd.cls();
    }
    
    void syncScreen()
    {
        int x, y, xLimit;
        
        for ( y = 0; y < SCREEN_HEIGHT; y++ ) {
            for ( x = 0; x < SCREEN_WIDTH; x++ ) {
                if ( cram[y][x] != lastWritten[y][x] )
                    break;
            }
            if ( x >= SCREEN_WIDTH ) {
                continue;
            }
            for ( xLimit = SCREEN_WIDTH - 1; cram[y][xLimit] == lastWritten[y][xLimit]; xLimit-- )
                ;   // empty loop body
            lcd.locate(x,y);
            for ( ;x <= xLimit; x++ ) {
                lcd.putc(cram[y][x]);
            }
        }
        for ( y = 0; y < SCREEN_HEIGHT; y++ ) {
            memcpy(&(lastWritten[y][0]), &(cram[y][0]), SCREEN_WIDTH);
        }
    }
    
    void scroll()
    {
        int x;
        for ( x = 0; x < SCREEN_WIDTH; x++ ) {
            cram[0][x] = cram[1][x];
            cram[1][x] = ' ';
        }
    }
    
    void print(const unsigned char *data)
    {
        const unsigned char *p;
        for ( p = data; *p != '\0'; p++ ) {
            if ( *p == CR ) {
                cursorX = 0;
            } else if ( *p == LF ) {
                cursorY++;
            } else if ( 0x20 <= *p && *p <= 0x7f ) {
                if ( cursorX >= SCREEN_WIDTH ) {
                    cursorX = 0;
                    cursorY++;
                }
                if ( cursorY >= SCREEN_HEIGHT ) {
                    scroll();
                    cursorY = SCREEN_HEIGHT - 1;
                }
                cram[cursorY][cursorX++] = *p;
            }
        }
        if ( cursorX >= SCREEN_WIDTH ) {
            cursorX = 0;
            ++cursorY;
        }
        syncScreen();
    }
};