#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

DigitalOut  myled1(LED1);
DigitalOut  myled2(LED2);
DigitalOut  myled3(LED3);
DigitalOut  myled4(LED4);

#include "WiFiScanner.h"
#include "LocationHandler.h"

int main() {
    WiFiScanner *wifiScanner = new WiFiScanner();
    lcd.printf("Start configuration.");
    
    wifiScanner->reset();
    wifiScanner->serialInit();
    
    lcd.cls();
    lcd.printf("baud rate matched.");
    
    wifiScanner->waitStartup();

    lcd.cls();
    lcd.printf("TMD3591AD ready.");
    wifiScanner->scanMode();
    
    lcd.cls();
    lcd.printf("start scan");
    while (true) {
        int i;
        myled1 = 1;
        myled2 = 1;
        myled3 = 1;
        myled4 = 1;
        wifiScanner->doScan();
        LocationManagerCalcPos(apinfo_count, apinfos);
        for ( i = 1; i <= 5; i++ ) {
            myled1 = (i >>3) & 1;
            myled2 = (i >>2) & 1;
            myled3 = (i >>1) & 1;
            myled4 = i & 1;
            wait(1.0);
        }

    }
}

