#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D8,D10,D11,D12,D13,D14); // rs, e, d4, d5, d6, d7)      //LCD出力設定
AnalogIn sw1(A5);       //スイッチ1入力設定
AnalogIn sw2(A4);       //スイッチ2入力設定

int main()
{
    char c = 0;             //SWのカウント数
    
    lcd.cls();             //画面をリセット
    
    lcd.locate(0,0);            //表示座標
    lcd.puts("push switch");      //表示文字
    
    lcd.locate(0,1);            //表示座標
    lcd.puts("00");         //表示文字
    
    while(1)                //無限ループ
    {
        if(sw1 == 1)    //SWが押されると{}内を実行
        {
            wait(0.25);      //チャタリング除去(スイッチの振動で入力が1回以上入るのを防ぐため)
            c++;        //カウント値に1足す
            
            if(c > 99)  //カウント値が99になったとき{}内実行
            {
                c = 0;      //カウント値初期化
            }

            lcd.locate(0,1);            //表示座標
            lcd.putc((c / 10) % 10 + '0');      //表示文字
            lcd.putc((c / 1) % 10 + '0');       //表示文字
        }
    }
}
