/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLEDevice.h"

#define BLE_UUID_NUS_SERVICE            0x0001 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_NUS_TX_CHARACTERISTIC  0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUID_NUS_RX_CHARACTERISTIC  0x0003 /**< The UUID of the RX Characteristic. */

#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
//Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

Serial  pc(USBTX, USBRX);
BLEDevice  ble;
DigitalOut led1(LED1);

#define USE_BLE_SERIAL_UUID 0   //BLESerialのUUIDを使う時１にする
/*#if USE_BLE_SERIAL_UUID
// BLESerial
const static char  DEVICE_NAME[] = "BLESerial";
static const uint8_t uart_base_uuid[] = {0x56,0x9a,0x11,0x01,0xb8,0x7F,0x49,0x0c,0x92,0xcb,0x11,0xba,0x5e,0xa5,0x16,0x7c};
static const uint8_t uart_tx_uuid[]   = {0x56,0x9a,0x20,0x01,0xb8,0x7F,0x49,0x0c,0x92,0xcb,0x11,0xba,0x5e,0xa5,0x16,0x7c};
static const uint8_t uart_rx_uuid[]   = {0x56,0x9a,0x20,0x00,0xb8,0x7F,0x49,0x0c,0x92,0xcb,0x11,0xba,0x5e,0xa5,0x16,0x7c};
static const uint8_t uart_base_uuid_rev[] = {0x7c,0x16,0xa5,0x5e,0xba,0x11,0xcb,0x92,0x0c,0x49,0x7F,0xb8,0x01,0x11,0x9a,0x56};
#else*/
// The Nordic UART Service
const static char  DEVICE_NAME[] = "mbed HRM1017";
static const uint8_t uart_base_uuid[] = {0x6e, 0x40, 0x00, 0x01, 0xb5, 0xa3, 0xf3, 0x93, 0xe0, 0xa9, 0xe5,0x0e, 0x24, 0xdc, 0xca, 0x9e};
static const uint8_t uart_tx_uuid[]   = {0x6e, 0x40, 0x00, 0x02, 0xb5, 0xa3, 0xf3, 0x93, 0xe0, 0xa9, 0xe5,0x0e, 0x24, 0xdc, 0xca, 0x9e};
static const uint8_t uart_rx_uuid[]   = {0x6e, 0x40, 0x00, 0x03, 0xb5, 0xa3, 0xf3, 0x93, 0xe0, 0xa9, 0xe5,0x0e, 0x24, 0xdc, 0xca, 0x9e};
static const uint8_t uart_base_uuid_rev[] = {0x9e, 0xca, 0xdc, 0x24, 0x0e, 0xe5, 0xa9, 0xe0, 0x93, 0xf3, 0xa3, 0xb5, 0x01, 0x00, 0x40, 0x6e};
//#endif

/*static const uint8_t SIZEOF_TX_BUFFER = 21;
uint8_t             thermSCANPayload[SIZEOF_TX_BUFFER] = {0,};// = { 0, 0, 0, 0, 0 };
GattCharacteristic  SCANChar(GattCharacteristic::UUID_SCAN_INTERVAL_WINDOW_CHAR,
                                thermSCANPayload, 1, SIZEOF_TX_BUFFER,
//                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ|
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE|
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE
//                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE
//                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_INDICATE
                                );*/
//static const uint8_t SIZEOF_TX_RX_BUFFER = 128;
static const uint8_t SIZEOF_TX_RX_BUFFER = 21;
uint8_t rxPayload[SIZEOF_TX_RX_BUFFER] = {0,};
uint8_t txPayload[SIZEOF_TX_RX_BUFFER] = {0,};
GattCharacteristic  rxCharacteristic (uart_tx_uuid, rxPayload, 1, SIZEOF_TX_RX_BUFFER,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE|
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  txCharacteristic (uart_rx_uuid, txPayload, 1, SIZEOF_TX_RX_BUFFER, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *uartChars[] = {&rxCharacteristic, &txCharacteristic/*,&SCANChar*/};
GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    DEBUG("Disconnected!\n\r");
    led1 = 1;
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}
void onConnectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *params)
{
    DEBUG("connected. Got handle %u\r\n", handle);
    led1 = 0;
}

void onDataWritten(uint16_t charHandle, const GattCharacteristicWriteCBParams *params)
{
    DEBUG("received handle=%d bytes\n\r", charHandle);
    if (charHandle == rxCharacteristic.getValueAttribute().getHandle()) {
        uint16_t bytesRead = params->len;
        DEBUG("received %u bytes\n\r", bytesRead);
        if (bytesRead < sizeof(rxPayload)) {
            memcpy(rxPayload, params->data, bytesRead);
            rxPayload[bytesRead] = 0;
        }
        DEBUG("ECHO: %s\n\r", (char *)rxPayload);
#if NEED_CONSOLE_OUTPUT
        ble.updateCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), rxPayload, bytesRead);
#else
        /*
        for(int i = 0; i < bytesRead; i++) {
            pc.putc(rxPayload[i]);
        }
        */
        switch( bytesRead ){
        case 1:
            pc.printf("%c",rxPayload[0]);
        case 2:
            pc.printf("%c%c",rxPayload[0],rxPayload[1]);
        case 3:
            pc.printf("%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2]);
        case 4:
            pc.printf("%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3]);
        case 5:
            pc.printf("%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4]);
        case 6:
            pc.printf("%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5]);
        case 7:
            pc.printf("%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6]);
        case 8:
            pc.printf("%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7]);
        case 9:
            pc.printf("%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8]);
        case 10:
            pc.printf("%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9]);
        case 11:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10]);
        case 12:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11]);
        case 13:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12]);
        case 14:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13]);
        case 15:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14]);
        case 16:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14],rxPayload[15]);
        case 17:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14],rxPayload[15],rxPayload[16]);
        case 18:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14],rxPayload[15],rxPayload[16],rxPayload[17]);
        case 19:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14],rxPayload[15],rxPayload[16],rxPayload[17],rxPayload[18]);
        case 20:
            pc.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",rxPayload[0],rxPayload[1],rxPayload[2],rxPayload[3],rxPayload[4],rxPayload[5],rxPayload[6],rxPayload[7],rxPayload[8],rxPayload[9],rxPayload[10],rxPayload[11],rxPayload[12],rxPayload[13],rxPayload[14],rxPayload[15],rxPayload[16],rxPayload[17],rxPayload[18],rxPayload[19]);
        }
#endif  //NEED_CONSOLE_OUTPUT
    }
}

static volatile bool uartTxUpdatesEnable = false;
void onUpdatesEnabled(uint16_t charHandle)
{
    DEBUG("onUpdatesEnabled handle %u!\n\r", charHandle);
    if (charHandle == txCharacteristic.getValueAttribute().getHandle()) {
        DEBUG("uartRxCharacteristic!\n\r");
        uartTxUpdatesEnable = true;
    }              
}
void onUpdatesDisabled(uint16_t charHandle)
{
    DEBUG("onUpdatesDisabled handle %u!\n\r", charHandle);
    if (charHandle == txCharacteristic.getValueAttribute().getHandle()) {
        DEBUG("uartRxCharacteristic!\n\r");
        uartTxUpdatesEnable = false;
    }                     
}
static volatile bool triggerUartPolling = false;

static int eventcount = 0;

void periodicCallback(void)
{
//    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    triggerUartPolling = true;
    eventcount++;
}

int main(void)
{
    led1 = 1;
    uint16_t bytesRead = 0;
    Ticker ticker;
    ticker.attach(periodicCallback, 0.05 );       //50ms

    pc.baud(38400);
    
#if NEED_CONSOLE_OUTPUT
//    pc.baud(38400);
#endif

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.setDeviceName((uint8_t *)DEVICE_NAME);
    ble.onConnection(onConnectionCallback);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);
    ble.onUpdatesEnabled(onUpdatesEnabled);
    ble.onUpdatesDisabled(onUpdatesDisabled);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
#if USE_BLE_SERIAL_UUID
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"BLESerial", sizeof("BLESerial") - 1);
#else
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"HRM1017", sizeof("HRM1017") - 1);
#endif
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    ble.setAdvertisingInterval(80); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    ble.addService(uartService);
    
    while (true) {
        if (triggerUartPolling) {
//            triggerUartPolling = false;
            /* Do blocking calls or whatever is necessary for sensor polling. */
            if(ble.getGapState().connected) { 
//#if !NEED_CONSOLE_OUTPUT
                if(uartTxUpdatesEnable) {
                    bytesRead = 0;
                    eventcount = 0;
                    while( bytesRead < sizeof(txPayload) - 1 )  {
                        if ( bytesRead < sizeof(txPayload)  - 1) {
                            if ( pc.readable() ){
                                txPayload[bytesRead++] = pc.getc();
/*                            } else if ( bytesRead > 0 ) {
                                ble.waitForEvent();*/
                            }
                        } else {
                            break;
                        }
                        if ( eventcount > 10 ){
                            break;
                        }
                    }
                    if ( bytesRead <= sizeof(txPayload) - 1 ) {
                        ble.updateCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), (uint8_t*)txPayload, bytesRead);
                    }
                }
//#endif
            }
        } else {
            ble.waitForEvent();
        }
    }
}
